package physx.support;

import physx.NativeObject;

public class PxArray_PxReal extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArray_PxReal wrapPointer(long address) {
        return address != 0L ? new PxArray_PxReal(address) : null;
    }
    
    public static PxArray_PxReal arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArray_PxReal(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxArray_PxReal
     */
    public static PxArray_PxReal createAt(long address) {
        __placement_new_PxArray_PxReal(address);
        PxArray_PxReal createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxArray_PxReal
     */
    public static <T> PxArray_PxReal createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxReal(address);
        PxArray_PxReal createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxReal(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param size    WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxReal
     */
    public static PxArray_PxReal createAt(long address, int size) {
        __placement_new_PxArray_PxReal(address, size);
        PxArray_PxReal createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param size      WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxReal
     */
    public static <T> PxArray_PxReal createAt(T allocator, Allocator<T> allocate, int size) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxReal(address, size);
        PxArray_PxReal createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxReal(long address, int size);

    // Constructors

    public PxArray_PxReal() {
        address = _PxArray_PxReal();
    }
    private static native long _PxArray_PxReal();

    /**
     * @param size WebIDL type: unsigned long
     */
    public PxArray_PxReal(int size) {
        address = _PxArray_PxReal(size);
    }
    private static native long _PxArray_PxReal(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float get(int index) {
        checkNotNull();
        return _get(address, index);
    }
    private static native float _get(long address, int index);

    /**
     * @param index WebIDL type: unsigned long
     * @param value WebIDL type: float
     */
    public void set(int index, float value) {
        checkNotNull();
        _set(address, index, value);
    }
    private static native void _set(long address, int index, float value);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject begin() {
        checkNotNull();
        return NativeObject.wrapPointer(_begin(address));
    }
    private static native long _begin(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: float
     */
    public void pushBack(float value) {
        checkNotNull();
        _pushBack(address, value);
    }
    private static native void _pushBack(long address, float value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
