package physx.vehicle2;

import physx.NativeObject;

public class DirectDrivetrainState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static DirectDrivetrainState wrapPointer(long address) {
        return address != 0L ? new DirectDrivetrainState(address) : null;
    }
    
    public static DirectDrivetrainState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected DirectDrivetrainState(long address) {
        super(address);
    }

    // Constructors

    public DirectDrivetrainState() {
        address = _DirectDrivetrainState();
    }
    private static native long _DirectDrivetrainState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getDirectDriveThrottleResponseStates(int index) {
        checkNotNull();
        return _getDirectDriveThrottleResponseStates(address, index);
    }
    private static native float _getDirectDriveThrottleResponseStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setDirectDriveThrottleResponseStates(int index, float value) {
        checkNotNull();
        _setDirectDriveThrottleResponseStates(address, index, value);
    }
    private static native void _setDirectDriveThrottleResponseStates(long address, int index, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
