package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxMat33;

public class PxVehicleFrame extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleFrame wrapPointer(long address) {
        return address != 0L ? new PxVehicleFrame(address) : null;
    }
    
    public static PxVehicleFrame arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleFrame(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleFrame() {
        address = _PxVehicleFrame();
    }
    private static native long _PxVehicleFrame();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The axis defining the longitudinal (forward) direction of the vehicle.
     */
    public PxVehicleAxesEnum getLngAxis() {
        checkNotNull();
        return PxVehicleAxesEnum.forValue(_getLngAxis(address));
    }
    private static native int _getLngAxis(long address);

    /**
     * The axis defining the longitudinal (forward) direction of the vehicle.
     */
    public void setLngAxis(PxVehicleAxesEnum value) {
        checkNotNull();
        _setLngAxis(address, value.value);
    }
    private static native void _setLngAxis(long address, int value);

    /**
     * The axis defining the lateral (side) direction of the vehicle.
     */
    public PxVehicleAxesEnum getLatAxis() {
        checkNotNull();
        return PxVehicleAxesEnum.forValue(_getLatAxis(address));
    }
    private static native int _getLatAxis(long address);

    /**
     * The axis defining the lateral (side) direction of the vehicle.
     */
    public void setLatAxis(PxVehicleAxesEnum value) {
        checkNotNull();
        _setLatAxis(address, value.value);
    }
    private static native void _setLatAxis(long address, int value);

    /**
     * The axis defining the vertical (up) direction of the vehicle.
     */
    public PxVehicleAxesEnum getVrtAxis() {
        checkNotNull();
        return PxVehicleAxesEnum.forValue(_getVrtAxis(address));
    }
    private static native int _getVrtAxis(long address);

    /**
     * The axis defining the vertical (up) direction of the vehicle.
     */
    public void setVrtAxis(PxVehicleAxesEnum value) {
        checkNotNull();
        _setVrtAxis(address, value.value);
    }
    private static native void _setVrtAxis(long address, int value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: {@link PxMat33} [Value]
     */
    public PxMat33 getFrame() {
        checkNotNull();
        return PxMat33.wrapPointer(_getFrame(address));
    }
    private static native long _getFrame(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
