package physx.vhacd;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.support.PxRealConstPtr;
import physx.support.PxU32ConstPtr;

public class VHACDImpl extends NativeObject {

    static {
        PlatformChecks.requirePlatform(15, "physx.vhacd.VHACDImpl");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static VHACDImpl wrapPointer(long address) {
        return address != 0L ? new VHACDImpl(address) : null;
    }
    
    public static VHACDImpl arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected VHACDImpl(long address) {
        super(address);
    }

    // Constructors

    public VHACDImpl() {
        address = _VHACDImpl();
    }
    private static native long _VHACDImpl();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param points         WebIDL type: {@link PxRealConstPtr} [Const, Ref]
     * @param countPoints    WebIDL type: unsigned long
     * @param triangles      WebIDL type: {@link PxU32ConstPtr} [Const, Ref]
     * @param countTriangles WebIDL type: unsigned long
     * @param params         WebIDL type: {@link VHACDParameters} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean Compute(PxRealConstPtr points, int countPoints, PxU32ConstPtr triangles, int countTriangles, VHACDParameters params) {
        checkNotNull();
        return _Compute(address, points.getAddress(), countPoints, triangles.getAddress(), countTriangles, params.getAddress());
    }
    private static native boolean _Compute(long address, long points, int countPoints, long triangles, int countTriangles, long params);

    /**
     * @return WebIDL type: unsigned long
     */
    public int GetNConvexHulls() {
        checkNotNull();
        return _GetNConvexHulls(address);
    }
    private static native int _GetNConvexHulls(long address);

    /**
     * @param index WebIDL type: unsigned long
     * @param ch    WebIDL type: {@link VHACDConvexHull} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean GetConvexHull(int index, VHACDConvexHull ch) {
        checkNotNull();
        return _GetConvexHull(address, index, ch.getAddress());
    }
    private static native boolean _GetConvexHull(long address, int index, long ch);

}
