package physx.vhacd;

import physx.NativeObject;
import physx.PlatformChecks;

public class VHACDTriangle extends NativeObject {

    static {
        PlatformChecks.requirePlatform(15, "physx.vhacd.VHACDTriangle");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static VHACDTriangle wrapPointer(long address) {
        return address != 0L ? new VHACDTriangle(address) : null;
    }
    
    public static VHACDTriangle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected VHACDTriangle(long address) {
        super(address);
    }

    // Constructors

    public VHACDTriangle() {
        address = _VHACDTriangle();
    }
    private static native long _VHACDTriangle();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMI0() {
        checkNotNull();
        return _getMI0(address);
    }
    private static native int _getMI0(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMI0(int value) {
        checkNotNull();
        _setMI0(address, value);
    }
    private static native void _setMI0(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMI1() {
        checkNotNull();
        return _getMI1(address);
    }
    private static native int _getMI1(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMI1(int value) {
        checkNotNull();
        _setMI1(address, value);
    }
    private static native void _setMI1(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMI2() {
        checkNotNull();
        return _getMI2(address);
    }
    private static native int _getMI2(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMI2(int value) {
        checkNotNull();
        _setMI2(address, value);
    }
    private static native void _setMI2(long address, int value);

}
