package physx.common;

import physx.NativeObject;

public class PxBase extends NativeObject {

    protected PxBase() { }

    public static PxBase wrapPointer(long address) {
        return new PxBase(address);
    }
    
    protected PxBase(long address) {
        super(address);
    }

    // Functions

    public void release() {
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @return DOMString [Const]
     */
    public String getConcreteTypeName() {
        return _getConcreteTypeName(address);
    }
    private static native String _getConcreteTypeName(long address);

    /**
     * @return long
     */
    public int getConcreteType() {
        return _getConcreteType(address);
    }
    private static native int _getConcreteType(long address);

    /**
     * @param flag  {@link PxBaseFlagEnum} [enum]
     * @param value boolean
     */
    public void setBaseFlag(int flag, boolean value) {
        _setBaseFlag(address, flag, value);
    }
    private static native void _setBaseFlag(long address, int flag, boolean value);

    /**
     * @param inFlags {@link PxBaseFlags} [Ref]
     */
    public void setBaseFlags(PxBaseFlags inFlags) {
        _setBaseFlags(address, inFlags.getAddress());
    }
    private static native void _setBaseFlags(long address, long inFlags);

    /**
     * @return {@link PxBaseFlags} [Value]
     */
    public PxBaseFlags getBaseFlags() {
        return PxBaseFlags.wrapPointer(_getBaseFlags(address));
    }
    private static native long _getBaseFlags(long address);

    /**
     * @return boolean
     */
    public boolean isReleasable() {
        return _isReleasable(address);
    }
    private static native boolean _isReleasable(long address);

}
