package physx.common;

import physx.NativeObject;

public class PxBoundedData extends NativeObject {

    protected PxBoundedData() { }

    public static PxBoundedData wrapPointer(long address) {
        return new PxBoundedData(address);
    }
    
    protected PxBoundedData(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return unsigned long
     */
    public int getCount() {
        return _getCount(address);
    }
    private static native int _getCount(long address);

    /**
     * @param value unsigned long
     */
    public void setCount(int value) {
        _setCount(address, value);
    }
    private static native void _setCount(long address, int value);

    /**
     * @return unsigned long
     */
    public int getStride() {
        return _getStride(address);
    }
    private static native int _getStride(long address);

    /**
     * @param value unsigned long
     */
    public void setStride(int value) {
        _setStride(address, value);
    }
    private static native void _setStride(long address, int value);

    /**
     * @return VoidPtr [Const]
     */
    public NativeObject getData() {
        return NativeObject.wrapPointer(_getData(address));
    }
    private static native long _getData(long address);

    /**
     * @param value VoidPtr [Const]
     */
    public void setData(NativeObject value) {
        _setData(address, value.getAddress());
    }
    private static native void _setData(long address, long value);

}
