package physx.common;

import physx.NativeObject;

public class PxRealPtr extends NativeObject {

    protected PxRealPtr() { }

    public static PxRealPtr wrapPointer(long address) {
        return new PxRealPtr(address);
    }
    
    protected PxRealPtr(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
