package physx.common;

import physx.NativeObject;

public class PxTransform extends NativeObject {

    protected PxTransform() { }

    public static PxTransform wrapPointer(long address) {
        return new PxTransform(address);
    }
    
    protected PxTransform(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address where the object is allocated
     * @param r       {@link PxIDENTITYEnum} [enum]
     * @return Stack allocated object of PxTransform
     */
    public static PxTransform malloc(long address, int r) {
        __placement_new_PxTransform(address, r);
        PxTransform mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param r         {@link PxIDENTITYEnum} [enum]
     * @return Stack allocated object of PxTransform
     */
    public static <T> PxTransform malloc(T allocator, Allocator<T> allocate, int r) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTransform(address, r);
        PxTransform mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    private static native void __placement_new_PxTransform(long address, int r);

    /**
     * @param address where the object is allocated
     * @param p0      {@link PxVec3} [Const, Ref]
     * @param q0      {@link PxQuat} [Const, Ref]
     * @return Stack allocated object of PxTransform
     */
    public static PxTransform malloc(long address, PxVec3 p0, PxQuat q0) {
        __placement_new_PxTransform(address, p0.getAddress(), q0.getAddress());
        PxTransform mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param p0        {@link PxVec3} [Const, Ref]
     * @param q0        {@link PxQuat} [Const, Ref]
     * @return Stack allocated object of PxTransform
     */
    public static <T> PxTransform malloc(T allocator, Allocator<T> allocate, PxVec3 p0, PxQuat q0) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTransform(address, p0.getAddress(), q0.getAddress());
        PxTransform mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    private static native void __placement_new_PxTransform(long address, long p0, long q0);

    // Constructors

    /**
     * @param r {@link PxIDENTITYEnum} [enum]
     */
    public PxTransform(int r) {
        address = _PxTransform(r);
    }
    private static native long _PxTransform(int r);

    /**
     * @param p0 {@link PxVec3} [Const, Ref]
     * @param q0 {@link PxQuat} [Const, Ref]
     */
    public PxTransform(PxVec3 p0, PxQuat q0) {
        address = _PxTransform(p0.getAddress(), q0.getAddress());
    }
    private static native long _PxTransform(long p0, long q0);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return {@link PxQuat} [Value]
     */
    public PxQuat getQ() {
        return PxQuat.wrapPointer(_getQ(address));
    }
    private static native long _getQ(long address);

    /**
     * @param value {@link PxQuat} [Value]
     */
    public void setQ(PxQuat value) {
        _setQ(address, value.getAddress());
    }
    private static native void _setQ(long address, long value);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getP() {
        return PxVec3.wrapPointer(_getP(address));
    }
    private static native long _getP(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setP(PxVec3 value) {
        _setP(address, value.getAddress());
    }
    private static native void _setP(long address, long value);

}
