package physx.cooking;

import physx.NativeObject;
import physx.common.PxBoundedData;

public class PxConvexMeshDesc extends NativeObject {

    public static PxConvexMeshDesc wrapPointer(long address) {
        return new PxConvexMeshDesc(address);
    }
    
    protected PxConvexMeshDesc(long address) {
        super(address);
    }

    // Constructors

    public PxConvexMeshDesc() {
        address = _PxConvexMeshDesc();
    }
    private static native long _PxConvexMeshDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return {@link PxBoundedData} [Value]
     */
    public PxBoundedData getPoints() {
        return PxBoundedData.wrapPointer(_getPoints(address));
    }
    private static native long _getPoints(long address);

    /**
     * @param value {@link PxBoundedData} [Value]
     */
    public void setPoints(PxBoundedData value) {
        _setPoints(address, value.getAddress());
    }
    private static native void _setPoints(long address, long value);

    /**
     * @return {@link PxConvexFlags} [Value]
     */
    public PxConvexFlags getFlags() {
        return PxConvexFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value {@link PxConvexFlags} [Value]
     */
    public void setFlags(PxConvexFlags value) {
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

}
