package physx.geomutils;


public class PxCapsuleGeometry extends PxGeometry {

    protected PxCapsuleGeometry() { }

    public static PxCapsuleGeometry wrapPointer(long address) {
        return new PxCapsuleGeometry(address);
    }
    
    protected PxCapsuleGeometry(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param radius     float
     * @param halfHeight float
     */
    public PxCapsuleGeometry(float radius, float halfHeight) {
        address = _PxCapsuleGeometry(radius, halfHeight);
    }
    private static native long _PxCapsuleGeometry(float radius, float halfHeight);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
