package physx.geomutils;


public class PxConvexMeshGeometry extends PxGeometry {

    protected PxConvexMeshGeometry() { }

    public static PxConvexMeshGeometry wrapPointer(long address) {
        return new PxConvexMeshGeometry(address);
    }
    
    protected PxConvexMeshGeometry(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param mesh {@link PxConvexMesh}
     */
    public PxConvexMeshGeometry(PxConvexMesh mesh) {
        address = _PxConvexMeshGeometry(mesh.getAddress());
    }
    private static native long _PxConvexMeshGeometry(long mesh);

    /**
     * @param mesh    {@link PxConvexMesh}
     * @param scaling {@link PxMeshScale} [Const, Ref]
     */
    public PxConvexMeshGeometry(PxConvexMesh mesh, PxMeshScale scaling) {
        address = _PxConvexMeshGeometry(mesh.getAddress(), scaling.getAddress());
    }
    private static native long _PxConvexMeshGeometry(long mesh, long scaling);

    /**
     * @param mesh    {@link PxConvexMesh}
     * @param scaling {@link PxMeshScale} [Const, Ref]
     * @param flags   {@link PxConvexMeshGeometryFlags} [Ref]
     */
    public PxConvexMeshGeometry(PxConvexMesh mesh, PxMeshScale scaling, PxConvexMeshGeometryFlags flags) {
        address = _PxConvexMeshGeometry(mesh.getAddress(), scaling.getAddress(), flags.getAddress());
    }
    private static native long _PxConvexMeshGeometry(long mesh, long scaling, long flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
