package physx.physics;

import physx.NativeObject;

public class PxActorFlags extends NativeObject {

    protected PxActorFlags() { }

    public static PxActorFlags wrapPointer(long address) {
        return new PxActorFlags(address);
    }
    
    protected PxActorFlags(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address where the object is allocated
     * @param flags   octet
     * @return Stack allocated object of PxActorFlags
     */
    public static PxActorFlags malloc(long address, byte flags) {
        __placement_new_PxActorFlags(address, flags);
        PxActorFlags mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     octet
     * @return Stack allocated object of PxActorFlags
     */
    public static <T> PxActorFlags malloc(T allocator, Allocator<T> allocate, byte flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxActorFlags(address, flags);
        PxActorFlags mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    private static native void __placement_new_PxActorFlags(long address, byte flags);

    // Constructors

    /**
     * @param flags octet
     */
    public PxActorFlags(byte flags) {
        address = _PxActorFlags(flags);
    }
    private static native long _PxActorFlags(byte flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag {@link PxActorFlagEnum} [enum]
     * @return boolean
     */
    public boolean isSet(int flag) {
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag {@link PxActorFlagEnum} [enum]
     */
    public void set(int flag) {
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag {@link PxActorFlagEnum} [enum]
     */
    public void clear(int flag) {
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
