package physx.physics;

import physx.NativeObject;

public class PxBatchQueryDesc extends NativeObject {

    protected PxBatchQueryDesc() { }

    public static PxBatchQueryDesc wrapPointer(long address) {
        return new PxBatchQueryDesc(address);
    }
    
    protected PxBatchQueryDesc(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param maxRaycastsPerExecute unsigned long
     * @param maxSweepsPerExecute   unsigned long
     * @param maxOverlapsPerExecute unsigned long
     */
    public PxBatchQueryDesc(int maxRaycastsPerExecute, int maxSweepsPerExecute, int maxOverlapsPerExecute) {
        address = _PxBatchQueryDesc(maxRaycastsPerExecute, maxSweepsPerExecute, maxOverlapsPerExecute);
    }
    private static native long _PxBatchQueryDesc(int maxRaycastsPerExecute, int maxSweepsPerExecute, int maxOverlapsPerExecute);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return any
     */
    public NativeObject getFilterShaderData() {
        return NativeObject.wrapPointer(_getFilterShaderData(address));
    }
    private static native long _getFilterShaderData(long address);

    /**
     * @param value any
     */
    public void setFilterShaderData(NativeObject value) {
        _setFilterShaderData(address, value.getAddress());
    }
    private static native void _setFilterShaderData(long address, long value);

    /**
     * @return unsigned long
     */
    public int getFilterShaderDataSize() {
        return _getFilterShaderDataSize(address);
    }
    private static native int _getFilterShaderDataSize(long address);

    /**
     * @param value unsigned long
     */
    public void setFilterShaderDataSize(int value) {
        _setFilterShaderDataSize(address, value);
    }
    private static native void _setFilterShaderDataSize(long address, int value);

    /**
     * @return {@link PxBatchQueryPreFilterShader} [Value]
     */
    public PxBatchQueryPreFilterShader getPreFilterShader() {
        long tmp = _getPreFilterShader(address);
        return (tmp != 0L ? PxBatchQueryPreFilterShader.wrapPointer(tmp) : null);
    }
    private static native long _getPreFilterShader(long address);

    /**
     * @param value {@link PxBatchQueryPreFilterShader} [Value]
     */
    public void setPreFilterShader(PxBatchQueryPreFilterShader value) {
        _setPreFilterShader(address, (value != null ? value.getAddress() : 0L));
    }
    private static native void _setPreFilterShader(long address, long value);

    /**
     * @return {@link PxBatchQueryPostFilterShader} [Value]
     */
    public PxBatchQueryPostFilterShader getPostFilterShader() {
        long tmp = _getPostFilterShader(address);
        return (tmp != 0L ? PxBatchQueryPostFilterShader.wrapPointer(tmp) : null);
    }
    private static native long _getPostFilterShader(long address);

    /**
     * @param value {@link PxBatchQueryPostFilterShader} [Value]
     */
    public void setPostFilterShader(PxBatchQueryPostFilterShader value) {
        _setPostFilterShader(address, (value != null ? value.getAddress() : 0L));
    }
    private static native void _setPostFilterShader(long address, long value);

    /**
     * @return {@link PxBatchQueryMemory} [Value]
     */
    public PxBatchQueryMemory getQueryMemory() {
        return PxBatchQueryMemory.wrapPointer(_getQueryMemory(address));
    }
    private static native long _getQueryMemory(long address);

    /**
     * @param value {@link PxBatchQueryMemory} [Value]
     */
    public void setQueryMemory(PxBatchQueryMemory value) {
        _setQueryMemory(address, value.getAddress());
    }
    private static native void _setQueryMemory(long address, long value);

    // Functions

    /**
     * @return boolean
     */
    public boolean isValid() {
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
