package physx.physics;

import physx.NativeObject;

public class PxBatchQueryMemory extends NativeObject {

    protected PxBatchQueryMemory() { }

    public static PxBatchQueryMemory wrapPointer(long address) {
        return new PxBatchQueryMemory(address);
    }
    
    protected PxBatchQueryMemory(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return {@link PxRaycastQueryResult}
     */
    public PxRaycastQueryResult getUserRaycastResultBuffer() {
        return PxRaycastQueryResult.wrapPointer(_getUserRaycastResultBuffer(address));
    }
    private static native long _getUserRaycastResultBuffer(long address);

    /**
     * @param value {@link PxRaycastQueryResult}
     */
    public void setUserRaycastResultBuffer(PxRaycastQueryResult value) {
        _setUserRaycastResultBuffer(address, value.getAddress());
    }
    private static native void _setUserRaycastResultBuffer(long address, long value);

    /**
     * @return {@link PxRaycastHit}
     */
    public PxRaycastHit getUserRaycastTouchBuffer() {
        return PxRaycastHit.wrapPointer(_getUserRaycastTouchBuffer(address));
    }
    private static native long _getUserRaycastTouchBuffer(long address);

    /**
     * @param value {@link PxRaycastHit}
     */
    public void setUserRaycastTouchBuffer(PxRaycastHit value) {
        _setUserRaycastTouchBuffer(address, value.getAddress());
    }
    private static native void _setUserRaycastTouchBuffer(long address, long value);

    /**
     * @return {@link PxSweepQueryResult}
     */
    public PxSweepQueryResult getUserSweepResultBuffer() {
        return PxSweepQueryResult.wrapPointer(_getUserSweepResultBuffer(address));
    }
    private static native long _getUserSweepResultBuffer(long address);

    /**
     * @param value {@link PxSweepQueryResult}
     */
    public void setUserSweepResultBuffer(PxSweepQueryResult value) {
        _setUserSweepResultBuffer(address, value.getAddress());
    }
    private static native void _setUserSweepResultBuffer(long address, long value);

    /**
     * @return {@link PxSweepHit}
     */
    public PxSweepHit getUserSweepTouchBuffer() {
        return PxSweepHit.wrapPointer(_getUserSweepTouchBuffer(address));
    }
    private static native long _getUserSweepTouchBuffer(long address);

    /**
     * @param value {@link PxSweepHit}
     */
    public void setUserSweepTouchBuffer(PxSweepHit value) {
        _setUserSweepTouchBuffer(address, value.getAddress());
    }
    private static native void _setUserSweepTouchBuffer(long address, long value);

    /**
     * @return {@link PxOverlapQueryResult}
     */
    public PxOverlapQueryResult getUserOverlapResultBuffer() {
        return PxOverlapQueryResult.wrapPointer(_getUserOverlapResultBuffer(address));
    }
    private static native long _getUserOverlapResultBuffer(long address);

    /**
     * @param value {@link PxOverlapQueryResult}
     */
    public void setUserOverlapResultBuffer(PxOverlapQueryResult value) {
        _setUserOverlapResultBuffer(address, value.getAddress());
    }
    private static native void _setUserOverlapResultBuffer(long address, long value);

    /**
     * @return {@link PxOverlapHit}
     */
    public PxOverlapHit getUserOverlapTouchBuffer() {
        return PxOverlapHit.wrapPointer(_getUserOverlapTouchBuffer(address));
    }
    private static native long _getUserOverlapTouchBuffer(long address);

    /**
     * @param value {@link PxOverlapHit}
     */
    public void setUserOverlapTouchBuffer(PxOverlapHit value) {
        _setUserOverlapTouchBuffer(address, value.getAddress());
    }
    private static native void _setUserOverlapTouchBuffer(long address, long value);

    /**
     * @return unsigned long
     */
    public int getRaycastTouchBufferSize() {
        return _getRaycastTouchBufferSize(address);
    }
    private static native int _getRaycastTouchBufferSize(long address);

    /**
     * @param value unsigned long
     */
    public void setRaycastTouchBufferSize(int value) {
        _setRaycastTouchBufferSize(address, value);
    }
    private static native void _setRaycastTouchBufferSize(long address, int value);

    /**
     * @return unsigned long
     */
    public int getSweepTouchBufferSize() {
        return _getSweepTouchBufferSize(address);
    }
    private static native int _getSweepTouchBufferSize(long address);

    /**
     * @param value unsigned long
     */
    public void setSweepTouchBufferSize(int value) {
        _setSweepTouchBufferSize(address, value);
    }
    private static native void _setSweepTouchBufferSize(long address, int value);

    /**
     * @return unsigned long
     */
    public int getOverlapTouchBufferSize() {
        return _getOverlapTouchBufferSize(address);
    }
    private static native int _getOverlapTouchBufferSize(long address);

    /**
     * @param value unsigned long
     */
    public void setOverlapTouchBufferSize(int value) {
        _setOverlapTouchBufferSize(address, value);
    }
    private static native void _setOverlapTouchBufferSize(long address, int value);

}
