package physx.physics;

import physx.NativeObject;

public class PxOverlapQueryResult extends NativeObject {

    protected PxOverlapQueryResult() { }

    public static PxOverlapQueryResult wrapPointer(long address) {
        return new PxOverlapQueryResult(address);
    }
    
    protected PxOverlapQueryResult(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return {@link PxOverlapHit} [Value]
     */
    public PxOverlapHit getBlock() {
        return PxOverlapHit.wrapPointer(_getBlock(address));
    }
    private static native long _getBlock(long address);

    /**
     * @param value {@link PxOverlapHit} [Value]
     */
    public void setBlock(PxOverlapHit value) {
        _setBlock(address, value.getAddress());
    }
    private static native void _setBlock(long address, long value);

    /**
     * @return {@link PxOverlapHit}
     */
    public PxOverlapHit getTouches() {
        return PxOverlapHit.wrapPointer(_getTouches(address));
    }
    private static native long _getTouches(long address);

    /**
     * @param value {@link PxOverlapHit}
     */
    public void setTouches(PxOverlapHit value) {
        _setTouches(address, value.getAddress());
    }
    private static native void _setTouches(long address, long value);

    /**
     * @return unsigned long
     */
    public int getNbTouches() {
        return _getNbTouches(address);
    }
    private static native int _getNbTouches(long address);

    /**
     * @param value unsigned long
     */
    public void setNbTouches(int value) {
        _setNbTouches(address, value);
    }
    private static native void _setNbTouches(long address, int value);

    /**
     * @return any
     */
    public NativeObject getUserData() {
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value any
     */
    public void setUserData(NativeObject value) {
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    /**
     * @return octet
     */
    public byte getQueryStatus() {
        return _getQueryStatus(address);
    }
    private static native byte _getQueryStatus(long address);

    /**
     * @param value octet
     */
    public void setQueryStatus(byte value) {
        _setQueryStatus(address, value);
    }
    private static native void _setQueryStatus(long address, byte value);

    /**
     * @return boolean
     */
    public boolean getHasBlock() {
        return _getHasBlock(address);
    }
    private static native boolean _getHasBlock(long address);

    /**
     * @param value boolean
     */
    public void setHasBlock(boolean value) {
        _setHasBlock(address, value);
    }
    private static native void _setHasBlock(long address, boolean value);

    // Functions

    /**
     * @return unsigned long
     */
    public int getNbAnyHits() {
        return _getNbAnyHits(address);
    }
    private static native int _getNbAnyHits(long address);

    /**
     * @param index unsigned long
     * @return {@link PxOverlapHit} [Const, Ref]
     */
    public PxOverlapHit getAnyHit(int index) {
        return PxOverlapHit.wrapPointer(_getAnyHit(address, index));
    }
    private static native long _getAnyHit(long address, int index);

}
