package physx.physics;

import physx.NativeObject;
import physx.common.PxFoundation;
import physx.common.PxPhysicsInsertionCallback;
import physx.common.PxTolerancesScale;
import physx.common.PxTransform;
import physx.geomutils.PxGeometry;

public class PxPhysics extends NativeObject {

    protected PxPhysics() { }

    public static PxPhysics wrapPointer(long address) {
        return new PxPhysics(address);
    }
    
    protected PxPhysics(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    public void release() {
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @return {@link PxFoundation} [Ref]
     */
    public PxFoundation getFoundation() {
        return PxFoundation.wrapPointer(_getFoundation(address));
    }
    private static native long _getFoundation(long address);

    /**
     * @return {@link PxTolerancesScale} [Const, Ref]
     */
    public PxTolerancesScale getTolerancesScale() {
        return PxTolerancesScale.wrapPointer(_getTolerancesScale(address));
    }
    private static native long _getTolerancesScale(long address);

    /**
     * @param sceneDesc {@link PxSceneDesc} [Const, Ref]
     * @return {@link PxScene}
     */
    public PxScene createScene(PxSceneDesc sceneDesc) {
        return PxScene.wrapPointer(_createScene(address, sceneDesc.getAddress()));
    }
    private static native long _createScene(long address, long sceneDesc);

    /**
     * @param pose {@link PxTransform} [Const, Ref]
     * @return {@link PxRigidStatic}
     */
    public PxRigidStatic createRigidStatic(PxTransform pose) {
        return PxRigidStatic.wrapPointer(_createRigidStatic(address, pose.getAddress()));
    }
    private static native long _createRigidStatic(long address, long pose);

    /**
     * @param pose {@link PxTransform} [Const, Ref]
     * @return {@link PxRigidDynamic}
     */
    public PxRigidDynamic createRigidDynamic(PxTransform pose) {
        return PxRigidDynamic.wrapPointer(_createRigidDynamic(address, pose.getAddress()));
    }
    private static native long _createRigidDynamic(long address, long pose);

    /**
     * @param geometry {@link PxGeometry} [Const, Ref]
     * @param material {@link PxMaterial} [Const, Ref]
     * @return {@link PxShape}
     */
    public PxShape createShape(PxGeometry geometry, PxMaterial material) {
        return PxShape.wrapPointer(_createShape(address, geometry.getAddress(), material.getAddress()));
    }
    private static native long _createShape(long address, long geometry, long material);

    /**
     * @param geometry    {@link PxGeometry} [Const, Ref]
     * @param material    {@link PxMaterial} [Const, Ref]
     * @param isExclusive boolean
     * @return {@link PxShape}
     */
    public PxShape createShape(PxGeometry geometry, PxMaterial material, boolean isExclusive) {
        return PxShape.wrapPointer(_createShape(address, geometry.getAddress(), material.getAddress(), isExclusive));
    }
    private static native long _createShape(long address, long geometry, long material, boolean isExclusive);

    /**
     * @param geometry    {@link PxGeometry} [Const, Ref]
     * @param material    {@link PxMaterial} [Const, Ref]
     * @param isExclusive boolean
     * @param shapeFlags  {@link PxShapeFlags} [Ref]
     * @return {@link PxShape}
     */
    public PxShape createShape(PxGeometry geometry, PxMaterial material, boolean isExclusive, PxShapeFlags shapeFlags) {
        return PxShape.wrapPointer(_createShape(address, geometry.getAddress(), material.getAddress(), isExclusive, shapeFlags.getAddress()));
    }
    private static native long _createShape(long address, long geometry, long material, boolean isExclusive, long shapeFlags);

    /**
     * @return long
     */
    public int getNbShapes() {
        return _getNbShapes(address);
    }
    private static native int _getNbShapes(long address);

    /**
     * @param staticFriction  float
     * @param dynamicFriction float
     * @param restitution     float
     * @return {@link PxMaterial}
     */
    public PxMaterial createMaterial(float staticFriction, float dynamicFriction, float restitution) {
        return PxMaterial.wrapPointer(_createMaterial(address, staticFriction, dynamicFriction, restitution));
    }
    private static native long _createMaterial(long address, float staticFriction, float dynamicFriction, float restitution);

    /**
     * @return {@link PxPhysicsInsertionCallback} [Ref]
     */
    public PxPhysicsInsertionCallback getPhysicsInsertionCallback() {
        return PxPhysicsInsertionCallback.wrapPointer(_getPhysicsInsertionCallback(address));
    }
    private static native long _getPhysicsInsertionCallback(long address);

}
