package physx.physics;

import physx.common.PxTransform;
import physx.common.PxVec3;

public class PxRigidBody extends PxRigidActor {

    protected PxRigidBody() { }

    public static PxRigidBody wrapPointer(long address) {
        return new PxRigidBody(address);
    }
    
    protected PxRigidBody(long address) {
        super(address);
    }

    // Functions

    /**
     * @param pose {@link PxTransform} [Const, Ref]
     */
    public void setCMassLocalPose(PxTransform pose) {
        _setCMassLocalPose(address, pose.getAddress());
    }
    private static native void _setCMassLocalPose(long address, long pose);

    /**
     * @return {@link PxTransform} [Value]
     */
    public PxTransform getCMassLocalPose() {
        return PxTransform.wrapPointer(_getCMassLocalPose(address));
    }
    private static native long _getCMassLocalPose(long address);

    /**
     * @param mass float
     */
    public void setMass(float mass) {
        _setMass(address, mass);
    }
    private static native void _setMass(long address, float mass);

    /**
     * @return float
     */
    public float getMass() {
        return _getMass(address);
    }
    private static native float _getMass(long address);

    /**
     * @return float
     */
    public float getInvMass() {
        return _getInvMass(address);
    }
    private static native float _getInvMass(long address);

    /**
     * @param m {@link PxVec3} [Const, Ref]
     */
    public void setMassSpaceInertiaTensor(PxVec3 m) {
        _setMassSpaceInertiaTensor(address, m.getAddress());
    }
    private static native void _setMassSpaceInertiaTensor(long address, long m);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getMassSpaceInertiaTensor() {
        return PxVec3.wrapPointer(_getMassSpaceInertiaTensor(address));
    }
    private static native long _getMassSpaceInertiaTensor(long address);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getMassSpaceInvInertiaTensor() {
        return PxVec3.wrapPointer(_getMassSpaceInvInertiaTensor(address));
    }
    private static native long _getMassSpaceInvInertiaTensor(long address);

    /**
     * @param linDamp float
     */
    public void setLinearDamping(float linDamp) {
        _setLinearDamping(address, linDamp);
    }
    private static native void _setLinearDamping(long address, float linDamp);

    /**
     * @return float
     */
    public float getLinearDamping() {
        return _getLinearDamping(address);
    }
    private static native float _getLinearDamping(long address);

    /**
     * @param angDamp float
     */
    public void setAngularDamping(float angDamp) {
        _setAngularDamping(address, angDamp);
    }
    private static native void _setAngularDamping(long address, float angDamp);

    /**
     * @return float
     */
    public float getAngularDamping() {
        return _getAngularDamping(address);
    }
    private static native float _getAngularDamping(long address);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getLinearVelocity() {
        return PxVec3.wrapPointer(_getLinearVelocity(address));
    }
    private static native long _getLinearVelocity(long address);

    /**
     * @param linVel {@link PxVec3} [Const, Ref]
     */
    public void setLinearVelocity(PxVec3 linVel) {
        _setLinearVelocity(address, linVel.getAddress());
    }
    private static native void _setLinearVelocity(long address, long linVel);

    /**
     * @param linVel   {@link PxVec3} [Const, Ref]
     * @param autowake boolean
     */
    public void setLinearVelocity(PxVec3 linVel, boolean autowake) {
        _setLinearVelocity(address, linVel.getAddress(), autowake);
    }
    private static native void _setLinearVelocity(long address, long linVel, boolean autowake);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getAngularVelocity() {
        return PxVec3.wrapPointer(_getAngularVelocity(address));
    }
    private static native long _getAngularVelocity(long address);

    /**
     * @param angVel {@link PxVec3} [Const, Ref]
     */
    public void setAngularVelocity(PxVec3 angVel) {
        _setAngularVelocity(address, angVel.getAddress());
    }
    private static native void _setAngularVelocity(long address, long angVel);

    /**
     * @param angVel   {@link PxVec3} [Const, Ref]
     * @param autowake boolean
     */
    public void setAngularVelocity(PxVec3 angVel, boolean autowake) {
        _setAngularVelocity(address, angVel.getAddress(), autowake);
    }
    private static native void _setAngularVelocity(long address, long angVel, boolean autowake);

    /**
     * @return float
     */
    public float getMaxLinearVelocity() {
        return _getMaxLinearVelocity(address);
    }
    private static native float _getMaxLinearVelocity(long address);

    /**
     * @param maxLinVel float
     */
    public void setMaxLinearVelocity(float maxLinVel) {
        _setMaxLinearVelocity(address, maxLinVel);
    }
    private static native void _setMaxLinearVelocity(long address, float maxLinVel);

    /**
     * @return float
     */
    public float getMaxAngularVelocity() {
        return _getMaxAngularVelocity(address);
    }
    private static native float _getMaxAngularVelocity(long address);

    /**
     * @param maxAngVel float
     */
    public void setMaxAngularVelocity(float maxAngVel) {
        _setMaxAngularVelocity(address, maxAngVel);
    }
    private static native void _setMaxAngularVelocity(long address, float maxAngVel);

    /**
     * @param force {@link PxVec3} [Const, Ref]
     */
    public void addForce(PxVec3 force) {
        _addForce(address, force.getAddress());
    }
    private static native void _addForce(long address, long force);

    /**
     * @param force {@link PxVec3} [Const, Ref]
     * @param mode  {@link PxForceModeEnum} [enum]
     */
    public void addForce(PxVec3 force, int mode) {
        _addForce(address, force.getAddress(), mode);
    }
    private static native void _addForce(long address, long force, int mode);

    /**
     * @param force    {@link PxVec3} [Const, Ref]
     * @param mode     {@link PxForceModeEnum} [enum]
     * @param autowake boolean
     */
    public void addForce(PxVec3 force, int mode, boolean autowake) {
        _addForce(address, force.getAddress(), mode, autowake);
    }
    private static native void _addForce(long address, long force, int mode, boolean autowake);

    /**
     * @param torque {@link PxVec3} [Const, Ref]
     */
    public void addTorque(PxVec3 torque) {
        _addTorque(address, torque.getAddress());
    }
    private static native void _addTorque(long address, long torque);

    /**
     * @param torque {@link PxVec3} [Const, Ref]
     * @param mode   {@link PxForceModeEnum} [enum]
     */
    public void addTorque(PxVec3 torque, int mode) {
        _addTorque(address, torque.getAddress(), mode);
    }
    private static native void _addTorque(long address, long torque, int mode);

    /**
     * @param torque   {@link PxVec3} [Const, Ref]
     * @param mode     {@link PxForceModeEnum} [enum]
     * @param autowake boolean
     */
    public void addTorque(PxVec3 torque, int mode, boolean autowake) {
        _addTorque(address, torque.getAddress(), mode, autowake);
    }
    private static native void _addTorque(long address, long torque, int mode, boolean autowake);

    /**
     * @param mode {@link PxForceModeEnum} [enum]
     */
    public void clearForce(int mode) {
        _clearForce(address, mode);
    }
    private static native void _clearForce(long address, int mode);

    /**
     * @param mode {@link PxForceModeEnum} [enum]
     */
    public void clearTorque(int mode) {
        _clearTorque(address, mode);
    }
    private static native void _clearTorque(long address, int mode);

    /**
     * @param force  {@link PxVec3} [Const, Ref]
     * @param torque {@link PxVec3} [Const, Ref]
     */
    public void setForceAndTorque(PxVec3 force, PxVec3 torque) {
        _setForceAndTorque(address, force.getAddress(), torque.getAddress());
    }
    private static native void _setForceAndTorque(long address, long force, long torque);

    /**
     * @param force  {@link PxVec3} [Const, Ref]
     * @param torque {@link PxVec3} [Const, Ref]
     * @param mode   {@link PxForceModeEnum} [enum]
     */
    public void setForceAndTorque(PxVec3 force, PxVec3 torque, int mode) {
        _setForceAndTorque(address, force.getAddress(), torque.getAddress(), mode);
    }
    private static native void _setForceAndTorque(long address, long force, long torque, int mode);

    /**
     * @param flag  {@link PxRigidBodyFlagEnum} [enum]
     * @param value boolean
     */
    public void setRigidBodyFlag(int flag, boolean value) {
        _setRigidBodyFlag(address, flag, value);
    }
    private static native void _setRigidBodyFlag(long address, int flag, boolean value);

    /**
     * @param inFlags {@link PxRigidBodyFlags} [Ref]
     */
    public void setRigidBodyFlags(PxRigidBodyFlags inFlags) {
        _setRigidBodyFlags(address, inFlags.getAddress());
    }
    private static native void _setRigidBodyFlags(long address, long inFlags);

    /**
     * @return {@link PxRigidBodyFlags} [Value]
     */
    public PxRigidBodyFlags getRigidBodyFlags() {
        return PxRigidBodyFlags.wrapPointer(_getRigidBodyFlags(address));
    }
    private static native long _getRigidBodyFlags(long address);

    /**
     * @param advanceCoefficient float
     */
    public void setMinCCDAdvanceCoefficient(float advanceCoefficient) {
        _setMinCCDAdvanceCoefficient(address, advanceCoefficient);
    }
    private static native void _setMinCCDAdvanceCoefficient(long address, float advanceCoefficient);

    /**
     * @return float
     */
    public float getMinCCDAdvanceCoefficient() {
        return _getMinCCDAdvanceCoefficient(address);
    }
    private static native float _getMinCCDAdvanceCoefficient(long address);

    /**
     * @param biasClamp float
     */
    public void setMaxDepenetrationVelocity(float biasClamp) {
        _setMaxDepenetrationVelocity(address, biasClamp);
    }
    private static native void _setMaxDepenetrationVelocity(long address, float biasClamp);

    /**
     * @return float
     */
    public float getMaxDepenetrationVelocity() {
        return _getMaxDepenetrationVelocity(address);
    }
    private static native float _getMaxDepenetrationVelocity(long address);

    /**
     * @param maxImpulse float
     */
    public void setMaxContactImpulse(float maxImpulse) {
        _setMaxContactImpulse(address, maxImpulse);
    }
    private static native void _setMaxContactImpulse(long address, float maxImpulse);

    /**
     * @return float
     */
    public float getMaxContactImpulse() {
        return _getMaxContactImpulse(address);
    }
    private static native float _getMaxContactImpulse(long address);

    /**
     * @return unsigned long
     */
    public int getInternalIslandNodeIndex() {
        return _getInternalIslandNodeIndex(address);
    }
    private static native int _getInternalIslandNodeIndex(long address);

}
