package physx.physics;


public class PxRigidDynamic extends PxRigidBody {

    protected PxRigidDynamic() { }

    public static PxRigidDynamic wrapPointer(long address) {
        return new PxRigidDynamic(address);
    }
    
    protected PxRigidDynamic(long address) {
        super(address);
    }

    // Functions

    /**
     * @return boolean
     */
    public boolean isSleeping() {
        return _isSleeping(address);
    }
    private static native boolean _isSleeping(long address);

    /**
     * @param threshold float
     */
    public void setSleepThreshold(float threshold) {
        _setSleepThreshold(address, threshold);
    }
    private static native void _setSleepThreshold(long address, float threshold);

    /**
     * @return float
     */
    public float getSleepThreshold() {
        return _getSleepThreshold(address);
    }
    private static native float _getSleepThreshold(long address);

    /**
     * @param threshold float
     */
    public void setStabilizationThreshold(float threshold) {
        _setStabilizationThreshold(address, threshold);
    }
    private static native void _setStabilizationThreshold(long address, float threshold);

    /**
     * @return float
     */
    public float getStabilizationThreshold() {
        return _getStabilizationThreshold(address);
    }
    private static native float _getStabilizationThreshold(long address);

    /**
     * @return {@link PxRigidDynamicLockFlags} [Value]
     */
    public PxRigidDynamicLockFlags getRigidDynamicLockFlags() {
        return PxRigidDynamicLockFlags.wrapPointer(_getRigidDynamicLockFlags(address));
    }
    private static native long _getRigidDynamicLockFlags(long address);

    /**
     * @param flag  {@link PxRigidDynamicLockFlagEnum} [enum]
     * @param value boolean
     */
    public void setRigidDynamicLockFlag(int flag, boolean value) {
        _setRigidDynamicLockFlag(address, flag, value);
    }
    private static native void _setRigidDynamicLockFlag(long address, int flag, boolean value);

    /**
     * @param flags {@link PxRigidDynamicLockFlags} [Ref]
     */
    public void setRigidDynamicLockFlags(PxRigidDynamicLockFlags flags) {
        _setRigidDynamicLockFlags(address, flags.getAddress());
    }
    private static native void _setRigidDynamicLockFlags(long address, long flags);

    /**
     * @param wakeCounterValue float
     */
    public void setWakeCounter(float wakeCounterValue) {
        _setWakeCounter(address, wakeCounterValue);
    }
    private static native void _setWakeCounter(long address, float wakeCounterValue);

    /**
     * @return float
     */
    public float getWakeCounter() {
        return _getWakeCounter(address);
    }
    private static native float _getWakeCounter(long address);

    public void wakeUp() {
        _wakeUp(address);
    }
    private static native void _wakeUp(long address);

    public void putToSleep() {
        _putToSleep(address);
    }
    private static native void _putToSleep(long address);

    /**
     * @param minPositionIters unsigned long
     */
    public void setSolverIterationCounts(int minPositionIters) {
        _setSolverIterationCounts(address, minPositionIters);
    }
    private static native void _setSolverIterationCounts(long address, int minPositionIters);

    /**
     * @param minPositionIters unsigned long
     * @param minVelocityIters unsigned long
     */
    public void setSolverIterationCounts(int minPositionIters, int minVelocityIters) {
        _setSolverIterationCounts(address, minPositionIters, minVelocityIters);
    }
    private static native void _setSolverIterationCounts(long address, int minPositionIters, int minVelocityIters);

    /**
     * @return float
     */
    public float getContactReportThreshold() {
        return _getContactReportThreshold(address);
    }
    private static native float _getContactReportThreshold(long address);

    /**
     * @param threshold float
     */
    public void setContactReportThreshold(float threshold) {
        _setContactReportThreshold(address, threshold);
    }
    private static native void _setContactReportThreshold(long address, float threshold);

}
