package physx.physics;


public class SimplePxSimulationEventCallback extends PxSimulationEventCallback {

    protected SimplePxSimulationEventCallback() { }

    public static SimplePxSimulationEventCallback wrapPointer(long address) {
        return new SimplePxSimulationEventCallback(address);
    }
    
    protected SimplePxSimulationEventCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param count unsigned long
     */
    public void cbFun(int count) {
        _cbFun(address, count);
    }
    private static native void _cbFun(long address, int count);

}
