package physx.support;

import physx.NativeObject;
import physx.physics.PxSweepQueryResult;

public class Vector_PxSweepQueryResult extends NativeObject {

    public static Vector_PxSweepQueryResult wrapPointer(long address) {
        return new Vector_PxSweepQueryResult(address);
    }
    
    protected Vector_PxSweepQueryResult(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxSweepQueryResult() {
        address = _Vector_PxSweepQueryResult();
    }
    private static native long _Vector_PxSweepQueryResult();

    /**
     * @param size unsigned long
     */
    public Vector_PxSweepQueryResult(int size) {
        address = _Vector_PxSweepQueryResult(size);
    }
    private static native long _Vector_PxSweepQueryResult(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index unsigned long
     * @return {@link PxSweepQueryResult} [Ref]
     */
    public PxSweepQueryResult at(int index) {
        return PxSweepQueryResult.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return {@link PxSweepQueryResult}
     */
    public PxSweepQueryResult data() {
        return PxSweepQueryResult.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return unsigned long
     */
    public int size() {
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value {@link PxSweepQueryResult} [Ref]
     */
    public void push_back(PxSweepQueryResult value) {
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

}
