package physx.support;

import physx.NativeObject;
import physx.vehicle.PxVehicleDrivableSurfaceType;

public class Vector_PxVehicleDrivableSurfaceType extends NativeObject {

    public static Vector_PxVehicleDrivableSurfaceType wrapPointer(long address) {
        return new Vector_PxVehicleDrivableSurfaceType(address);
    }
    
    protected Vector_PxVehicleDrivableSurfaceType(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxVehicleDrivableSurfaceType() {
        address = _Vector_PxVehicleDrivableSurfaceType();
    }
    private static native long _Vector_PxVehicleDrivableSurfaceType();

    /**
     * @param size unsigned long
     */
    public Vector_PxVehicleDrivableSurfaceType(int size) {
        address = _Vector_PxVehicleDrivableSurfaceType(size);
    }
    private static native long _Vector_PxVehicleDrivableSurfaceType(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index unsigned long
     * @return {@link PxVehicleDrivableSurfaceType} [Ref]
     */
    public PxVehicleDrivableSurfaceType at(int index) {
        return PxVehicleDrivableSurfaceType.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return {@link PxVehicleDrivableSurfaceType}
     */
    public PxVehicleDrivableSurfaceType data() {
        return PxVehicleDrivableSurfaceType.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return unsigned long
     */
    public int size() {
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value {@link PxVehicleDrivableSurfaceType} [Ref]
     */
    public void push_back(PxVehicleDrivableSurfaceType value) {
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

}
