package physx.support;

import physx.NativeObject;
import physx.vehicle.PxVehicleWheels;

public class Vector_PxVehicleWheels extends NativeObject {

    public static Vector_PxVehicleWheels wrapPointer(long address) {
        return new Vector_PxVehicleWheels(address);
    }
    
    protected Vector_PxVehicleWheels(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxVehicleWheels() {
        address = _Vector_PxVehicleWheels();
    }
    private static native long _Vector_PxVehicleWheels();

    /**
     * @param size unsigned long
     */
    public Vector_PxVehicleWheels(int size) {
        address = _Vector_PxVehicleWheels(size);
    }
    private static native long _Vector_PxVehicleWheels(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index unsigned long
     * @return {@link PxVehicleWheels}
     */
    public PxVehicleWheels at(int index) {
        return PxVehicleWheels.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return {@link PxVehicleWheelsPtr}
     */
    public PxVehicleWheelsPtr data() {
        return PxVehicleWheelsPtr.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return unsigned long
     */
    public int size() {
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value {@link PxVehicleWheels}
     */
    public void push_back(PxVehicleWheels value) {
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

}
