package physx.vehicle;

import physx.NativeObject;

public class PxVehicleClutchData extends NativeObject {

    public static PxVehicleClutchData wrapPointer(long address) {
        return new PxVehicleClutchData(address);
    }
    
    protected PxVehicleClutchData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleClutchData() {
        address = _PxVehicleClutchData();
    }
    private static native long _PxVehicleClutchData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return float
     */
    public float getMStrength() {
        return _getMStrength(address);
    }
    private static native float _getMStrength(long address);

    /**
     * @param value float
     */
    public void setMStrength(float value) {
        _setMStrength(address, value);
    }
    private static native void _setMStrength(long address, float value);

    /**
     * @return {@link PxVehicleClutchAccuracyModeEnum} [enum]
     */
    public int getMAccuracyMode() {
        return _getMAccuracyMode(address);
    }
    private static native int _getMAccuracyMode(long address);

    /**
     * @param value {@link PxVehicleClutchAccuracyModeEnum} [enum]
     */
    public void setMAccuracyMode(int value) {
        _setMAccuracyMode(address, value);
    }
    private static native void _setMAccuracyMode(long address, int value);

    /**
     * @return unsigned long
     */
    public int getMEstimateIterations() {
        return _getMEstimateIterations(address);
    }
    private static native int _getMEstimateIterations(long address);

    /**
     * @param value unsigned long
     */
    public void setMEstimateIterations(int value) {
        _setMEstimateIterations(address, value);
    }
    private static native void _setMEstimateIterations(long address, int value);

}
