package physx.vehicle;

import physx.NativeObject;

public class PxVehicleDifferential4WData extends NativeObject {

    public static PxVehicleDifferential4WData wrapPointer(long address) {
        return new PxVehicleDifferential4WData(address);
    }
    
    protected PxVehicleDifferential4WData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleDifferential4WData() {
        address = _PxVehicleDifferential4WData();
    }
    private static native long _PxVehicleDifferential4WData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return float
     */
    public float getMFrontRearSplit() {
        return _getMFrontRearSplit(address);
    }
    private static native float _getMFrontRearSplit(long address);

    /**
     * @param value float
     */
    public void setMFrontRearSplit(float value) {
        _setMFrontRearSplit(address, value);
    }
    private static native void _setMFrontRearSplit(long address, float value);

    /**
     * @return float
     */
    public float getMFrontLeftRightSplit() {
        return _getMFrontLeftRightSplit(address);
    }
    private static native float _getMFrontLeftRightSplit(long address);

    /**
     * @param value float
     */
    public void setMFrontLeftRightSplit(float value) {
        _setMFrontLeftRightSplit(address, value);
    }
    private static native void _setMFrontLeftRightSplit(long address, float value);

    /**
     * @return float
     */
    public float getMRearLeftRightSplit() {
        return _getMRearLeftRightSplit(address);
    }
    private static native float _getMRearLeftRightSplit(long address);

    /**
     * @param value float
     */
    public void setMRearLeftRightSplit(float value) {
        _setMRearLeftRightSplit(address, value);
    }
    private static native void _setMRearLeftRightSplit(long address, float value);

    /**
     * @return float
     */
    public float getMCentreBias() {
        return _getMCentreBias(address);
    }
    private static native float _getMCentreBias(long address);

    /**
     * @param value float
     */
    public void setMCentreBias(float value) {
        _setMCentreBias(address, value);
    }
    private static native void _setMCentreBias(long address, float value);

    /**
     * @return float
     */
    public float getMFrontBias() {
        return _getMFrontBias(address);
    }
    private static native float _getMFrontBias(long address);

    /**
     * @param value float
     */
    public void setMFrontBias(float value) {
        _setMFrontBias(address, value);
    }
    private static native void _setMFrontBias(long address, float value);

    /**
     * @return float
     */
    public float getMRearBias() {
        return _getMRearBias(address);
    }
    private static native float _getMRearBias(long address);

    /**
     * @param value float
     */
    public void setMRearBias(float value) {
        _setMRearBias(address, value);
    }
    private static native void _setMRearBias(long address, float value);

    /**
     * @return {@link PxVehicleDifferential4WDataEnum} [enum]
     */
    public int getMType() {
        return _getMType(address);
    }
    private static native int _getMType(long address);

    /**
     * @param value {@link PxVehicleDifferential4WDataEnum} [enum]
     */
    public void setMType(int value) {
        _setMType(address, value);
    }
    private static native void _setMType(long address, int value);

}
