package physx.vehicle;


public class PxVehicleDriveSimData4W extends PxVehicleDriveSimData {

    public static PxVehicleDriveSimData4W wrapPointer(long address) {
        return new PxVehicleDriveSimData4W(address);
    }
    
    protected PxVehicleDriveSimData4W(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleDriveSimData4W() {
        address = _PxVehicleDriveSimData4W();
    }
    private static native long _PxVehicleDriveSimData4W();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return {@link PxVehicleDifferential4WData} [Const, Ref]
     */
    public PxVehicleDifferential4WData getDiffData() {
        return PxVehicleDifferential4WData.wrapPointer(_getDiffData(address));
    }
    private static native long _getDiffData(long address);

    /**
     * @return {@link PxVehicleAckermannGeometryData} [Const, Ref]
     */
    public PxVehicleAckermannGeometryData getAckermannGeometryData() {
        return PxVehicleAckermannGeometryData.wrapPointer(_getAckermannGeometryData(address));
    }
    private static native long _getAckermannGeometryData(long address);

    /**
     * @param diff {@link PxVehicleDifferential4WData} [Const, Ref]
     */
    public void setDiffData(PxVehicleDifferential4WData diff) {
        _setDiffData(address, diff.getAddress());
    }
    private static native void _setDiffData(long address, long diff);

    /**
     * @param ackermannData {@link PxVehicleAckermannGeometryData} [Const, Ref]
     */
    public void setAckermannGeometryData(PxVehicleAckermannGeometryData ackermannData) {
        _setAckermannGeometryData(address, ackermannData.getAddress());
    }
    private static native void _setAckermannGeometryData(long address, long ackermannData);

}
