package physx.vehicle;

import physx.NativeObject;

public class PxVehicleGearsData extends NativeObject {

    public static PxVehicleGearsData wrapPointer(long address) {
        return new PxVehicleGearsData(address);
    }
    
    protected PxVehicleGearsData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleGearsData() {
        address = _PxVehicleGearsData();
    }
    private static native long _PxVehicleGearsData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return float
     */
    public float getMRatios(int index) {
        return _getMRatios(address, index);
    }
    private static native float _getMRatios(long address, int index);

    /**
     * @param index Array index
     * @param value float
     */
    public void setMRatios(int index, float value) {
        _setMRatios(address, index, value);
    }
    private static native void _setMRatios(long address, int index, float value);

    /**
     * @return float
     */
    public float getMFinalRatio() {
        return _getMFinalRatio(address);
    }
    private static native float _getMFinalRatio(long address);

    /**
     * @param value float
     */
    public void setMFinalRatio(float value) {
        _setMFinalRatio(address, value);
    }
    private static native void _setMFinalRatio(long address, float value);

    /**
     * @return unsigned long
     */
    public int getMNbRatios() {
        return _getMNbRatios(address);
    }
    private static native int _getMNbRatios(long address);

    /**
     * @param value unsigned long
     */
    public void setMNbRatios(int value) {
        _setMNbRatios(address, value);
    }
    private static native void _setMNbRatios(long address, int value);

    /**
     * @return float
     */
    public float getMSwitchTime() {
        return _getMSwitchTime(address);
    }
    private static native float _getMSwitchTime(long address);

    /**
     * @param value float
     */
    public void setMSwitchTime(float value) {
        _setMSwitchTime(address, value);
    }
    private static native void _setMSwitchTime(long address, float value);

    // Functions

    /**
     * @param a {@link PxVehicleGearEnum} [enum]
     * @return float
     */
    public float getGearRatio(int a) {
        return _getGearRatio(address, a);
    }
    private static native float _getGearRatio(long address, int a);

    /**
     * @param a     {@link PxVehicleGearEnum} [enum]
     * @param ratio float
     */
    public void setGearRatio(int a, float ratio) {
        _setGearRatio(address, a, ratio);
    }
    private static native void _setGearRatio(long address, int a, float ratio);

}
