package physx.vehicle;

import physx.NativeObject;

public class PxVehicleTireLoadFilterData extends NativeObject {

    public static PxVehicleTireLoadFilterData wrapPointer(long address) {
        return new PxVehicleTireLoadFilterData(address);
    }
    
    protected PxVehicleTireLoadFilterData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTireLoadFilterData() {
        address = _PxVehicleTireLoadFilterData();
    }
    private static native long _PxVehicleTireLoadFilterData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return float
     */
    public float getMMinNormalisedLoad() {
        return _getMMinNormalisedLoad(address);
    }
    private static native float _getMMinNormalisedLoad(long address);

    /**
     * @param value float
     */
    public void setMMinNormalisedLoad(float value) {
        _setMMinNormalisedLoad(address, value);
    }
    private static native void _setMMinNormalisedLoad(long address, float value);

    /**
     * @return float
     */
    public float getMMinFilteredNormalisedLoad() {
        return _getMMinFilteredNormalisedLoad(address);
    }
    private static native float _getMMinFilteredNormalisedLoad(long address);

    /**
     * @param value float
     */
    public void setMMinFilteredNormalisedLoad(float value) {
        _setMMinFilteredNormalisedLoad(address, value);
    }
    private static native void _setMMinFilteredNormalisedLoad(long address, float value);

    /**
     * @return float
     */
    public float getMMaxNormalisedLoad() {
        return _getMMaxNormalisedLoad(address);
    }
    private static native float _getMMaxNormalisedLoad(long address);

    /**
     * @param value float
     */
    public void setMMaxNormalisedLoad(float value) {
        _setMMaxNormalisedLoad(address, value);
    }
    private static native void _setMMaxNormalisedLoad(long address, float value);

    /**
     * @return float
     */
    public float getMMaxFilteredNormalisedLoad() {
        return _getMMaxFilteredNormalisedLoad(address);
    }
    private static native float _getMMaxFilteredNormalisedLoad(long address);

    /**
     * @param value float
     */
    public void setMMaxFilteredNormalisedLoad(float value) {
        _setMMaxFilteredNormalisedLoad(address, value);
    }
    private static native void _setMMaxFilteredNormalisedLoad(long address, float value);

    // Functions

    /**
     * @return float
     */
    public float getDenominator() {
        return _getDenominator(address);
    }
    private static native float _getDenominator(long address);

}
