package physx.vehicle;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxActor;
import physx.physics.PxMaterial;
import physx.physics.PxShape;

public class PxWheelQueryResult extends NativeObject {

    public static PxWheelQueryResult wrapPointer(long address) {
        return new PxWheelQueryResult(address);
    }
    
    protected PxWheelQueryResult(long address) {
        super(address);
    }

    // Constructors

    public PxWheelQueryResult() {
        address = _PxWheelQueryResult();
    }
    private static native long _PxWheelQueryResult();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getSuspLineStart() {
        return PxVec3.wrapPointer(_getSuspLineStart(address));
    }
    private static native long _getSuspLineStart(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setSuspLineStart(PxVec3 value) {
        _setSuspLineStart(address, value.getAddress());
    }
    private static native void _setSuspLineStart(long address, long value);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getSuspLineDir() {
        return PxVec3.wrapPointer(_getSuspLineDir(address));
    }
    private static native long _getSuspLineDir(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setSuspLineDir(PxVec3 value) {
        _setSuspLineDir(address, value.getAddress());
    }
    private static native void _setSuspLineDir(long address, long value);

    /**
     * @return float
     */
    public float getSuspLineLength() {
        return _getSuspLineLength(address);
    }
    private static native float _getSuspLineLength(long address);

    /**
     * @param value float
     */
    public void setSuspLineLength(float value) {
        _setSuspLineLength(address, value);
    }
    private static native void _setSuspLineLength(long address, float value);

    /**
     * @return boolean
     */
    public boolean getIsInAir() {
        return _getIsInAir(address);
    }
    private static native boolean _getIsInAir(long address);

    /**
     * @param value boolean
     */
    public void setIsInAir(boolean value) {
        _setIsInAir(address, value);
    }
    private static native void _setIsInAir(long address, boolean value);

    /**
     * @return {@link PxActor}
     */
    public PxActor getTireContactActor() {
        return PxActor.wrapPointer(_getTireContactActor(address));
    }
    private static native long _getTireContactActor(long address);

    /**
     * @param value {@link PxActor}
     */
    public void setTireContactActor(PxActor value) {
        _setTireContactActor(address, value.getAddress());
    }
    private static native void _setTireContactActor(long address, long value);

    /**
     * @return {@link PxShape}
     */
    public PxShape getTireContactShape() {
        return PxShape.wrapPointer(_getTireContactShape(address));
    }
    private static native long _getTireContactShape(long address);

    /**
     * @param value {@link PxShape}
     */
    public void setTireContactShape(PxShape value) {
        _setTireContactShape(address, value.getAddress());
    }
    private static native void _setTireContactShape(long address, long value);

    /**
     * @return {@link PxMaterial} [Const]
     */
    public PxMaterial getTireSurfaceMaterial() {
        return PxMaterial.wrapPointer(_getTireSurfaceMaterial(address));
    }
    private static native long _getTireSurfaceMaterial(long address);

    /**
     * @param value {@link PxMaterial} [Const]
     */
    public void setTireSurfaceMaterial(PxMaterial value) {
        _setTireSurfaceMaterial(address, value.getAddress());
    }
    private static native void _setTireSurfaceMaterial(long address, long value);

    /**
     * @return unsigned long
     */
    public int getTireSurfaceType() {
        return _getTireSurfaceType(address);
    }
    private static native int _getTireSurfaceType(long address);

    /**
     * @param value unsigned long
     */
    public void setTireSurfaceType(int value) {
        _setTireSurfaceType(address, value);
    }
    private static native void _setTireSurfaceType(long address, int value);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getTireContactPoint() {
        return PxVec3.wrapPointer(_getTireContactPoint(address));
    }
    private static native long _getTireContactPoint(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setTireContactPoint(PxVec3 value) {
        _setTireContactPoint(address, value.getAddress());
    }
    private static native void _setTireContactPoint(long address, long value);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getTireContactNormal() {
        return PxVec3.wrapPointer(_getTireContactNormal(address));
    }
    private static native long _getTireContactNormal(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setTireContactNormal(PxVec3 value) {
        _setTireContactNormal(address, value.getAddress());
    }
    private static native void _setTireContactNormal(long address, long value);

    /**
     * @return float
     */
    public float getTireFriction() {
        return _getTireFriction(address);
    }
    private static native float _getTireFriction(long address);

    /**
     * @param value float
     */
    public void setTireFriction(float value) {
        _setTireFriction(address, value);
    }
    private static native void _setTireFriction(long address, float value);

    /**
     * @return float
     */
    public float getSuspJounce() {
        return _getSuspJounce(address);
    }
    private static native float _getSuspJounce(long address);

    /**
     * @param value float
     */
    public void setSuspJounce(float value) {
        _setSuspJounce(address, value);
    }
    private static native void _setSuspJounce(long address, float value);

    /**
     * @return float
     */
    public float getSuspSpringForce() {
        return _getSuspSpringForce(address);
    }
    private static native float _getSuspSpringForce(long address);

    /**
     * @param value float
     */
    public void setSuspSpringForce(float value) {
        _setSuspSpringForce(address, value);
    }
    private static native void _setSuspSpringForce(long address, float value);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getTireLongitudinalDir() {
        return PxVec3.wrapPointer(_getTireLongitudinalDir(address));
    }
    private static native long _getTireLongitudinalDir(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setTireLongitudinalDir(PxVec3 value) {
        _setTireLongitudinalDir(address, value.getAddress());
    }
    private static native void _setTireLongitudinalDir(long address, long value);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getTireLateralDir() {
        return PxVec3.wrapPointer(_getTireLateralDir(address));
    }
    private static native long _getTireLateralDir(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setTireLateralDir(PxVec3 value) {
        _setTireLateralDir(address, value.getAddress());
    }
    private static native void _setTireLateralDir(long address, long value);

    /**
     * @return float
     */
    public float getLongitudinalSlip() {
        return _getLongitudinalSlip(address);
    }
    private static native float _getLongitudinalSlip(long address);

    /**
     * @param value float
     */
    public void setLongitudinalSlip(float value) {
        _setLongitudinalSlip(address, value);
    }
    private static native void _setLongitudinalSlip(long address, float value);

    /**
     * @return float
     */
    public float getLateralSlip() {
        return _getLateralSlip(address);
    }
    private static native float _getLateralSlip(long address);

    /**
     * @param value float
     */
    public void setLateralSlip(float value) {
        _setLateralSlip(address, value);
    }
    private static native void _setLateralSlip(long address, float value);

    /**
     * @return float
     */
    public float getSteerAngle() {
        return _getSteerAngle(address);
    }
    private static native float _getSteerAngle(long address);

    /**
     * @param value float
     */
    public void setSteerAngle(float value) {
        _setSteerAngle(address, value);
    }
    private static native void _setSteerAngle(long address, float value);

    /**
     * @return {@link PxTransform} [Value]
     */
    public PxTransform getLocalPose() {
        return PxTransform.wrapPointer(_getLocalPose(address));
    }
    private static native long _getLocalPose(long address);

    /**
     * @param value {@link PxTransform} [Value]
     */
    public void setLocalPose(PxTransform value) {
        _setLocalPose(address, value.getAddress());
    }
    private static native void _setLocalPose(long address, long value);

}
