/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxBounds3
extends NativeObject {
    public static PxBounds3 wrapPointer(long address) {
        return new PxBounds3(address);
    }

    protected PxBounds3(long address) {
        super(address);
    }

    public PxBounds3() {
        this.address = PxBounds3._PxBounds3();
    }

    private static native long _PxBounds3();

    public PxBounds3(PxVec3 minimum, PxVec3 maximum) {
        this.address = PxBounds3._PxBounds3(minimum.getAddress(), maximum.getAddress());
    }

    private static native long _PxBounds3(long var0, long var2);

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (this.isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        PxBounds3._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);

    public PxVec3 getMinimum() {
        return PxVec3.wrapPointer(PxBounds3._getMinimum(this.address));
    }

    private static native long _getMinimum(long var0);

    public void setMinimum(PxVec3 value) {
        PxBounds3._setMinimum(this.address, value.getAddress());
    }

    private static native void _setMinimum(long var0, long var2);

    public PxVec3 getMaximum() {
        return PxVec3.wrapPointer(PxBounds3._getMaximum(this.address));
    }

    private static native long _getMaximum(long var0);

    public void setMaximum(PxVec3 value) {
        PxBounds3._setMaximum(this.address, value.getAddress());
    }

    private static native void _setMaximum(long var0, long var2);

    public void setEmpty() {
        PxBounds3._setEmpty(this.address);
    }

    private static native void _setEmpty(long var0);

    public void setMaximal() {
        PxBounds3._setMaximal(this.address);
    }

    private static native void _setMaximal(long var0);

    public void include(PxVec3 v) {
        PxBounds3._include(this.address, v.getAddress());
    }

    private static native void _include(long var0, long var2);

    public boolean isEmpty() {
        return PxBounds3._isEmpty(this.address);
    }

    private static native boolean _isEmpty(long var0);

    public boolean intersects(PxBounds3 b) {
        return PxBounds3._intersects(this.address, b.getAddress());
    }

    private static native boolean _intersects(long var0, long var2);

    public boolean intersects1D(PxBounds3 b, int axis) {
        return PxBounds3._intersects1D(this.address, b.getAddress(), axis);
    }

    private static native boolean _intersects1D(long var0, long var2, int var4);

    public boolean contains(PxVec3 v) {
        return PxBounds3._contains(this.address, v.getAddress());
    }

    private static native boolean _contains(long var0, long var2);

    public boolean isInside(PxBounds3 box) {
        return PxBounds3._isInside(this.address, box.getAddress());
    }

    private static native boolean _isInside(long var0, long var2);

    public PxVec3 getCenter() {
        return PxVec3.wrapPointer(PxBounds3._getCenter(this.address));
    }

    private static native long _getCenter(long var0);

    public PxVec3 getDimensions() {
        return PxVec3.wrapPointer(PxBounds3._getDimensions(this.address));
    }

    private static native long _getDimensions(long var0);

    public PxVec3 getExtents() {
        return PxVec3.wrapPointer(PxBounds3._getExtents(this.address));
    }

    private static native long _getExtents(long var0);

    public void scaleSafe(float scale) {
        PxBounds3._scaleSafe(this.address, scale);
    }

    private static native void _scaleSafe(long var0, float var2);

    public void scaleFast(float scale) {
        PxBounds3._scaleFast(this.address, scale);
    }

    private static native void _scaleFast(long var0, float var2);

    public void fattenSafe(float distance) {
        PxBounds3._fattenSafe(this.address, distance);
    }

    private static native void _fattenSafe(long var0, float var2);

    public void fattenFast(float distance) {
        PxBounds3._fattenFast(this.address, distance);
    }

    private static native void _fattenFast(long var0, float var2);

    public boolean isFinite() {
        return PxBounds3._isFinite(this.address);
    }

    private static native boolean _isFinite(long var0);

    public boolean isValid() {
        return PxBounds3._isValid(this.address);
    }

    private static native boolean _isValid(long var0);
}

