/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.common.PxVec3;
import physx.physics.PxHitFlags;
import physx.physics.PxQueryHit;

public class PxLocationHit
extends PxQueryHit {
    protected PxLocationHit() {
    }

    public static PxLocationHit wrapPointer(long address) {
        return new PxLocationHit(address);
    }

    protected PxLocationHit(long address) {
        super(address);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (this.isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        PxLocationHit._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);

    public PxHitFlags getFlags() {
        return PxHitFlags.wrapPointer(PxLocationHit._getFlags(this.address));
    }

    private static native long _getFlags(long var0);

    public void setFlags(PxHitFlags value) {
        PxLocationHit._setFlags(this.address, value.getAddress());
    }

    private static native void _setFlags(long var0, long var2);

    public PxVec3 getPosition() {
        return PxVec3.wrapPointer(PxLocationHit._getPosition(this.address));
    }

    private static native long _getPosition(long var0);

    public void setPosition(PxVec3 value) {
        PxLocationHit._setPosition(this.address, value.getAddress());
    }

    private static native void _setPosition(long var0, long var2);

    public PxVec3 getNormal() {
        return PxVec3.wrapPointer(PxLocationHit._getNormal(this.address));
    }

    private static native long _getNormal(long var0);

    public void setNormal(PxVec3 value) {
        PxLocationHit._setNormal(this.address, value.getAddress());
    }

    private static native void _setNormal(long var0, long var2);

    public float getDistance() {
        return PxLocationHit._getDistance(this.address);
    }

    private static native float _getDistance(long var0);

    public void setDistance(float value) {
        PxLocationHit._setDistance(this.address, value);
    }

    private static native void _setDistance(long var0, float var2);
}

