/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.common.PxFoundation;
import physx.common.PxPhysicsInsertionCallback;
import physx.common.PxTolerancesScale;
import physx.common.PxTransform;
import physx.geomutils.PxGeometry;
import physx.physics.PxMaterial;
import physx.physics.PxRigidDynamic;
import physx.physics.PxRigidStatic;
import physx.physics.PxScene;
import physx.physics.PxSceneDesc;
import physx.physics.PxShape;
import physx.physics.PxShapeFlags;

public class PxPhysics
extends NativeObject {
    protected PxPhysics() {
    }

    public static PxPhysics wrapPointer(long address) {
        return new PxPhysics(address);
    }

    protected PxPhysics(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (this.isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        PxPhysics._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);

    public void release() {
        PxPhysics._release(this.address);
    }

    private static native void _release(long var0);

    public PxFoundation getFoundation() {
        return PxFoundation.wrapPointer(PxPhysics._getFoundation(this.address));
    }

    private static native long _getFoundation(long var0);

    public PxTolerancesScale getTolerancesScale() {
        return PxTolerancesScale.wrapPointer(PxPhysics._getTolerancesScale(this.address));
    }

    private static native long _getTolerancesScale(long var0);

    public PxScene createScene(PxSceneDesc sceneDesc) {
        return PxScene.wrapPointer(PxPhysics._createScene(this.address, sceneDesc.getAddress()));
    }

    private static native long _createScene(long var0, long var2);

    public PxRigidStatic createRigidStatic(PxTransform pose) {
        return PxRigidStatic.wrapPointer(PxPhysics._createRigidStatic(this.address, pose.getAddress()));
    }

    private static native long _createRigidStatic(long var0, long var2);

    public PxRigidDynamic createRigidDynamic(PxTransform pose) {
        return PxRigidDynamic.wrapPointer(PxPhysics._createRigidDynamic(this.address, pose.getAddress()));
    }

    private static native long _createRigidDynamic(long var0, long var2);

    public PxShape createShape(PxGeometry geometry, PxMaterial material) {
        return PxShape.wrapPointer(PxPhysics._createShape(this.address, geometry.getAddress(), material.getAddress()));
    }

    private static native long _createShape(long var0, long var2, long var4);

    public PxShape createShape(PxGeometry geometry, PxMaterial material, boolean isExclusive) {
        return PxShape.wrapPointer(PxPhysics._createShape(this.address, geometry.getAddress(), material.getAddress(), isExclusive));
    }

    private static native long _createShape(long var0, long var2, long var4, boolean var6);

    public PxShape createShape(PxGeometry geometry, PxMaterial material, boolean isExclusive, PxShapeFlags shapeFlags) {
        return PxShape.wrapPointer(PxPhysics._createShape(this.address, geometry.getAddress(), material.getAddress(), isExclusive, shapeFlags.getAddress()));
    }

    private static native long _createShape(long var0, long var2, long var4, boolean var6, long var7);

    public int getNbShapes() {
        return PxPhysics._getNbShapes(this.address);
    }

    private static native int _getNbShapes(long var0);

    public PxMaterial createMaterial(float staticFriction, float dynamicFriction, float restitution) {
        return PxMaterial.wrapPointer(PxPhysics._createMaterial(this.address, staticFriction, dynamicFriction, restitution));
    }

    private static native long _createMaterial(long var0, float var2, float var3, float var4);

    public PxPhysicsInsertionCallback getPhysicsInsertionCallback() {
        return PxPhysicsInsertionCallback.wrapPointer(PxPhysics._getPhysicsInsertionCallback(this.address));
    }

    private static native long _getPhysicsInsertionCallback(long var0);
}

