package physx.character;

import physx.NativeObject;

public class PxExtendedVec3 extends NativeObject {

    public static PxExtendedVec3 wrapPointer(long address) {
        return address != 0L ? new PxExtendedVec3(address) : null;
    }
    
    protected PxExtendedVec3(long address) {
        super(address);
    }

    // Constructors

    public PxExtendedVec3() {
        address = _PxExtendedVec3();
    }
    private static native long _PxExtendedVec3();

    /**
     * @param x WebIDL type: double
     * @param y WebIDL type: double
     * @param z WebIDL type: double
     */
    public PxExtendedVec3(double x, double y, double z) {
        address = _PxExtendedVec3(x, y, z);
    }
    private static native long _PxExtendedVec3(double x, double y, double z);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: double
     */
    public double getX() {
        checkNotNull();
        return _getX(address);
    }
    private static native double _getX(long address);

    /**
     * @param value WebIDL type: double
     */
    public void setX(double value) {
        checkNotNull();
        _setX(address, value);
    }
    private static native void _setX(long address, double value);

    /**
     * @return WebIDL type: double
     */
    public double getY() {
        checkNotNull();
        return _getY(address);
    }
    private static native double _getY(long address);

    /**
     * @param value WebIDL type: double
     */
    public void setY(double value) {
        checkNotNull();
        _setY(address, value);
    }
    private static native void _setY(long address, double value);

    /**
     * @return WebIDL type: double
     */
    public double getZ() {
        checkNotNull();
        return _getZ(address);
    }
    private static native double _getZ(long address);

    /**
     * @param value WebIDL type: double
     */
    public void setZ(double value) {
        checkNotNull();
        _setZ(address, value);
    }
    private static native void _setZ(long address, double value);

}
