package physx.character;

import physx.NativeObject;
import physx.common.PxQuat;
import physx.geomutils.PxGeometryTypeEnum;

public class PxObstacle extends NativeObject {

    protected PxObstacle() { }

    public static PxObstacle wrapPointer(long address) {
        return address != 0L ? new PxObstacle(address) : null;
    }
    
    protected PxObstacle(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getMUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getMUserData(address));
    }
    private static native long _getMUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setMUserData(NativeObject value) {
        checkNotNull();
        _setMUserData(address, value.getAddress());
    }
    private static native void _setMUserData(long address, long value);

    /**
     * @return WebIDL type: {@link PxExtendedVec3} [Value]
     */
    public PxExtendedVec3 getMPos() {
        checkNotNull();
        return PxExtendedVec3.wrapPointer(_getMPos(address));
    }
    private static native long _getMPos(long address);

    /**
     * @param value WebIDL type: {@link PxExtendedVec3} [Value]
     */
    public void setMPos(PxExtendedVec3 value) {
        checkNotNull();
        _setMPos(address, value.getAddress());
    }
    private static native void _setMPos(long address, long value);

    /**
     * @return WebIDL type: {@link PxQuat} [Value]
     */
    public PxQuat getMRot() {
        checkNotNull();
        return PxQuat.wrapPointer(_getMRot(address));
    }
    private static native long _getMRot(long address);

    /**
     * @param value WebIDL type: {@link PxQuat} [Value]
     */
    public void setMRot(PxQuat value) {
        checkNotNull();
        _setMRot(address, value.getAddress());
    }
    private static native void _setMRot(long address, long value);

    // Functions

    /**
     * @return WebIDL type: {@link PxGeometryTypeEnum} [enum]
     */
    public int getType() {
        checkNotNull();
        return _getType(address);
    }
    private static native int _getType(long address);

}
