package physx.physics;

import physx.common.PxBase;
import physx.common.PxBounds3;
import physx.common.PxTransform;

public class PxArticulationBase extends PxBase {

    protected PxArticulationBase() { }

    public static PxArticulationBase wrapPointer(long address) {
        return address != 0L ? new PxArticulationBase(address) : null;
    }
    
    protected PxArticulationBase(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: {@link PxScene}
     */
    public PxScene getScene() {
        checkNotNull();
        return PxScene.wrapPointer(_getScene(address));
    }
    private static native long _getScene(long address);

    /**
     * @param minPositionIters WebIDL type: unsigned long
     * @param minVelocityIters WebIDL type: unsigned long
     */
    public void setSolverIterationCounts(int minPositionIters, int minVelocityIters) {
        checkNotNull();
        _setSolverIterationCounts(address, minPositionIters, minVelocityIters);
    }
    private static native void _setSolverIterationCounts(long address, int minPositionIters, int minVelocityIters);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isSleeping() {
        checkNotNull();
        return _isSleeping(address);
    }
    private static native boolean _isSleeping(long address);

    /**
     * @param threshold WebIDL type: float
     */
    public void setSleepThreshold(float threshold) {
        checkNotNull();
        _setSleepThreshold(address, threshold);
    }
    private static native void _setSleepThreshold(long address, float threshold);

    /**
     * @return WebIDL type: float
     */
    public float getSleepThreshold() {
        checkNotNull();
        return _getSleepThreshold(address);
    }
    private static native float _getSleepThreshold(long address);

    /**
     * @param threshold WebIDL type: float
     */
    public void setStabilizationThreshold(float threshold) {
        checkNotNull();
        _setStabilizationThreshold(address, threshold);
    }
    private static native void _setStabilizationThreshold(long address, float threshold);

    /**
     * @return WebIDL type: float
     */
    public float getStabilizationThreshold() {
        checkNotNull();
        return _getStabilizationThreshold(address);
    }
    private static native float _getStabilizationThreshold(long address);

    /**
     * @param wakeCounterValue WebIDL type: float
     */
    public void setWakeCounter(float wakeCounterValue) {
        checkNotNull();
        _setWakeCounter(address, wakeCounterValue);
    }
    private static native void _setWakeCounter(long address, float wakeCounterValue);

    /**
     * @return WebIDL type: float
     */
    public float getWakeCounter() {
        checkNotNull();
        return _getWakeCounter(address);
    }
    private static native float _getWakeCounter(long address);

    public void wakeUp() {
        checkNotNull();
        _wakeUp(address);
    }
    private static native void _wakeUp(long address);

    public void putToSleep() {
        checkNotNull();
        _putToSleep(address);
    }
    private static native void _putToSleep(long address);

    /**
     * @param parent WebIDL type: {@link PxArticulationLink}
     * @param pose   WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: {@link PxArticulationLink}
     */
    public PxArticulationLink createLink(PxArticulationLink parent, PxTransform pose) {
        checkNotNull();
        return PxArticulationLink.wrapPointer(_createLink(address, (parent != null ? parent.getAddress() : 0L), pose.getAddress()));
    }
    private static native long _createLink(long address, long parent, long pose);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbLinks() {
        checkNotNull();
        return _getNbLinks(address);
    }
    private static native int _getNbLinks(long address);

    /**
     * @param name WebIDL type: DOMString [Const]
     */
    public void setName(String name) {
        checkNotNull();
        _setName(address, name);
    }
    private static native void _setName(long address, String name);

    /**
     * @return WebIDL type: DOMString [Const]
     */
    public String getName() {
        checkNotNull();
        return _getName(address);
    }
    private static native String _getName(long address);

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getWorldBounds() {
        checkNotNull();
        return PxBounds3.wrapPointer(_getWorldBounds(address));
    }
    private static native long _getWorldBounds(long address);

    /**
     * @return WebIDL type: {@link PxAggregate}
     */
    public PxAggregate getAggregate() {
        checkNotNull();
        return PxAggregate.wrapPointer(_getAggregate(address));
    }
    private static native long _getAggregate(long address);

}
