package physx.physics;

import physx.NativeObject;

public class PxContactPairHeader extends NativeObject {

    protected PxContactPairHeader() { }

    public static PxContactPairHeader wrapPointer(long address) {
        return address != 0L ? new PxContactPairHeader(address) : null;
    }
    
    protected PxContactPairHeader(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxRigidActor}
     */
    public PxRigidActor getActors(int index) {
        checkNotNull();
        return PxRigidActor.wrapPointer(_getActors(address, index));
    }
    private static native long _getActors(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxRigidActor}
     */
    public void setActors(int index, PxRigidActor value) {
        checkNotNull();
        _setActors(address, index, value.getAddress());
    }
    private static native void _setActors(long address, int index, long value);

    /**
     * @return WebIDL type: {@link PxContactPairHeaderFlags} [Value]
     */
    public PxContactPairHeaderFlags getFlags() {
        checkNotNull();
        return PxContactPairHeaderFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxContactPairHeaderFlags} [Value]
     */
    public void setFlags(PxContactPairHeaderFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

    /**
     * @return WebIDL type: {@link PxContactPair} [Const]
     */
    public PxContactPair getPairs() {
        checkNotNull();
        return PxContactPair.wrapPointer(_getPairs(address));
    }
    private static native long _getPairs(long address);

    /**
     * @param value WebIDL type: {@link PxContactPair} [Const]
     */
    public void setPairs(PxContactPair value) {
        checkNotNull();
        _setPairs(address, value.getAddress());
    }
    private static native void _setPairs(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbPairs() {
        checkNotNull();
        return _getNbPairs(address);
    }
    private static native int _getNbPairs(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbPairs(int value) {
        checkNotNull();
        _setNbPairs(address, value);
    }
    private static native void _setNbPairs(long address, int value);

}
