package physx.physics;

import physx.NativeObject;
import physx.common.PxBase;

public class PxMaterial extends PxBase {

    protected PxMaterial() { }

    public static PxMaterial wrapPointer(long address) {
        return address != 0L ? new PxMaterial(address) : null;
    }
    
    protected PxMaterial(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

}
