package physx.physics;


public class PxArticulationJointReducedCoordinate extends PxArticulationJointBase {

    protected PxArticulationJointReducedCoordinate() { }

    public static PxArticulationJointReducedCoordinate wrapPointer(long address) {
        return address != 0L ? new PxArticulationJointReducedCoordinate(address) : null;
    }
    
    protected PxArticulationJointReducedCoordinate(long address) {
        super(address);
    }

    // Functions

    /**
     * @param jointType WebIDL type: {@link PxArticulationJointTypeEnum} [enum]
     */
    public void setJointType(int jointType) {
        checkNotNull();
        _setJointType(address, jointType);
    }
    private static native void _setJointType(long address, int jointType);

    /**
     * @return WebIDL type: {@link PxArticulationJointTypeEnum} [enum]
     */
    public int getJointType() {
        checkNotNull();
        return _getJointType(address);
    }
    private static native int _getJointType(long address);

    /**
     * @param axis   WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param motion WebIDL type: {@link PxArticulationMotionEnum} [enum]
     */
    public void setMotion(int axis, int motion) {
        checkNotNull();
        _setMotion(address, axis, motion);
    }
    private static native void _setMotion(long address, int axis, int motion);

    /**
     * @param axis WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @return WebIDL type: {@link PxArticulationMotionEnum} [enum]
     */
    public int getMotion(int axis) {
        checkNotNull();
        return _getMotion(address, axis);
    }
    private static native int _getMotion(long address, int axis);

    /**
     * @param axis      WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param lowLimit  WebIDL type: float
     * @param highLimit WebIDL type: float
     */
    public void setLimit(int axis, float lowLimit, float highLimit) {
        checkNotNull();
        _setLimit(address, axis, lowLimit, highLimit);
    }
    private static native void _setLimit(long address, int axis, float lowLimit, float highLimit);

    /**
     * @param axis      WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param stiffness WebIDL type: float
     * @param damping   WebIDL type: float
     * @param maxForce  WebIDL type: float
     */
    public void setDrive(int axis, float stiffness, float damping, float maxForce) {
        checkNotNull();
        _setDrive(address, axis, stiffness, damping, maxForce);
    }
    private static native void _setDrive(long address, int axis, float stiffness, float damping, float maxForce);

    /**
     * @param axis      WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param stiffness WebIDL type: float
     * @param damping   WebIDL type: float
     * @param maxForce  WebIDL type: float
     * @param driveType WebIDL type: {@link PxArticulationDriveTypeEnum} [enum]
     */
    public void setDrive(int axis, float stiffness, float damping, float maxForce, int driveType) {
        checkNotNull();
        _setDrive(address, axis, stiffness, damping, maxForce, driveType);
    }
    private static native void _setDrive(long address, int axis, float stiffness, float damping, float maxForce, int driveType);

    /**
     * @param axis   WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param target WebIDL type: float
     */
    public void setDriveTarget(int axis, float target) {
        checkNotNull();
        _setDriveTarget(address, axis, target);
    }
    private static native void _setDriveTarget(long address, int axis, float target);

    /**
     * @param axis      WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param targetVel WebIDL type: float
     */
    public void setDriveVelocity(int axis, float targetVel) {
        checkNotNull();
        _setDriveVelocity(address, axis, targetVel);
    }
    private static native void _setDriveVelocity(long address, int axis, float targetVel);

    /**
     * @param axis WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @return WebIDL type: float
     */
    public float getDriveTarget(int axis) {
        checkNotNull();
        return _getDriveTarget(address, axis);
    }
    private static native float _getDriveTarget(long address, int axis);

    /**
     * @param axis WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @return WebIDL type: float
     */
    public float getDriveVelocity(int axis) {
        checkNotNull();
        return _getDriveVelocity(address, axis);
    }
    private static native float _getDriveVelocity(long address, int axis);

    /**
     * @param coefficient WebIDL type: float
     */
    public void setFrictionCoefficient(float coefficient) {
        checkNotNull();
        _setFrictionCoefficient(address, coefficient);
    }
    private static native void _setFrictionCoefficient(long address, float coefficient);

    /**
     * @return WebIDL type: float
     */
    public float getFrictionCoefficient() {
        checkNotNull();
        return _getFrictionCoefficient(address);
    }
    private static native float _getFrictionCoefficient(long address);

    /**
     * @param maxJointV WebIDL type: float
     */
    public void setMaxJointVelocity(float maxJointV) {
        checkNotNull();
        _setMaxJointVelocity(address, maxJointV);
    }
    private static native void _setMaxJointVelocity(long address, float maxJointV);

    /**
     * @return WebIDL type: float
     */
    public float getMaxJointVelocity() {
        checkNotNull();
        return _getMaxJointVelocity(address);
    }
    private static native float _getMaxJointVelocity(long address);

}
