package physx.support;

import physx.NativeObject;

public class Vector_PxU32 extends NativeObject {

    public static Vector_PxU32 wrapPointer(long address) {
        return address != 0L ? new Vector_PxU32(address) : null;
    }
    
    protected Vector_PxU32(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxU32() {
        address = _Vector_PxU32();
    }
    private static native long _Vector_PxU32();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxU32(int size) {
        address = _Vector_PxU32(size);
    }
    private static native long _Vector_PxU32(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int at(int index) {
        checkNotNull();
        return _at(address, index);
    }
    private static native int _at(long address, int index);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject data() {
        checkNotNull();
        return NativeObject.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void push_back(int value) {
        checkNotNull();
        _push_back(address, value);
    }
    private static native void _push_back(long address, int value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
