package physx.extensions;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxForceModeEnum;
import physx.physics.PxRigidBody;

public class PxRigidBodyExt extends NativeObject {

    protected PxRigidBodyExt() { }

    public static PxRigidBodyExt wrapPointer(long address) {
        return address != 0L ? new PxRigidBodyExt(address) : null;
    }
    
    protected PxRigidBodyExt(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param body    WebIDL type: {@link PxRigidBody} [Ref]
     * @param density WebIDL type: float
     * @return WebIDL type: boolean
     */
    public static boolean updateMassAndInertia(PxRigidBody body, float density) {
        return _updateMassAndInertia(body.getAddress(), density);
    }
    private static native boolean _updateMassAndInertia(long body, float density);

    /**
     * @param body          WebIDL type: {@link PxRigidBody} [Ref]
     * @param density       WebIDL type: float
     * @param massLocalPose WebIDL type: {@link PxVec3}
     * @return WebIDL type: boolean
     */
    public static boolean updateMassAndInertia(PxRigidBody body, float density, PxVec3 massLocalPose) {
        return _updateMassAndInertia(body.getAddress(), density, massLocalPose.getAddress());
    }
    private static native boolean _updateMassAndInertia(long body, float density, long massLocalPose);

    /**
     * @param body                WebIDL type: {@link PxRigidBody} [Ref]
     * @param density             WebIDL type: float
     * @param massLocalPose       WebIDL type: {@link PxVec3}
     * @param includeNonSimShapes WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public static boolean updateMassAndInertia(PxRigidBody body, float density, PxVec3 massLocalPose, boolean includeNonSimShapes) {
        return _updateMassAndInertia(body.getAddress(), density, massLocalPose.getAddress(), includeNonSimShapes);
    }
    private static native boolean _updateMassAndInertia(long body, float density, long massLocalPose, boolean includeNonSimShapes);

    /**
     * @param body WebIDL type: {@link PxRigidBody} [Ref]
     * @param mass WebIDL type: float
     * @return WebIDL type: boolean
     */
    public static boolean setMassAndUpdateInertia(PxRigidBody body, float mass) {
        return _setMassAndUpdateInertia(body.getAddress(), mass);
    }
    private static native boolean _setMassAndUpdateInertia(long body, float mass);

    /**
     * @param body          WebIDL type: {@link PxRigidBody} [Ref]
     * @param mass          WebIDL type: float
     * @param massLocalPose WebIDL type: {@link PxVec3}
     * @return WebIDL type: boolean
     */
    public static boolean setMassAndUpdateInertia(PxRigidBody body, float mass, PxVec3 massLocalPose) {
        return _setMassAndUpdateInertia(body.getAddress(), mass, massLocalPose.getAddress());
    }
    private static native boolean _setMassAndUpdateInertia(long body, float mass, long massLocalPose);

    /**
     * @param body                WebIDL type: {@link PxRigidBody} [Ref]
     * @param mass                WebIDL type: float
     * @param massLocalPose       WebIDL type: {@link PxVec3}
     * @param includeNonSimShapes WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public static boolean setMassAndUpdateInertia(PxRigidBody body, float mass, PxVec3 massLocalPose, boolean includeNonSimShapes) {
        return _setMassAndUpdateInertia(body.getAddress(), mass, massLocalPose.getAddress(), includeNonSimShapes);
    }
    private static native boolean _setMassAndUpdateInertia(long body, float mass, long massLocalPose, boolean includeNonSimShapes);

    /**
     * @param body  WebIDL type: {@link PxRigidBody} [Ref]
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos   WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public static void addForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos) {
        _addForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress());
    }
    private static native void _addForceAtPos(long body, long force, long pos);

    /**
     * @param body  WebIDL type: {@link PxRigidBody} [Ref]
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode  WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public static void addForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos, int mode) {
        _addForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode);
    }
    private static native void _addForceAtPos(long body, long force, long pos, int mode);

    /**
     * @param body   WebIDL type: {@link PxRigidBody} [Ref]
     * @param force  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode   WebIDL type: {@link PxForceModeEnum} [enum]
     * @param wakeup WebIDL type: boolean
     */
    public static void addForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos, int mode, boolean wakeup) {
        _addForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode, wakeup);
    }
    private static native void _addForceAtPos(long body, long force, long pos, int mode, boolean wakeup);

    /**
     * @param body  WebIDL type: {@link PxRigidBody} [Ref]
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos   WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public static void addForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos) {
        _addForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress());
    }
    private static native void _addForceAtLocalPos(long body, long force, long pos);

    /**
     * @param body  WebIDL type: {@link PxRigidBody} [Ref]
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode  WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public static void addForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos, int mode) {
        _addForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode);
    }
    private static native void _addForceAtLocalPos(long body, long force, long pos, int mode);

    /**
     * @param body   WebIDL type: {@link PxRigidBody} [Ref]
     * @param force  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode   WebIDL type: {@link PxForceModeEnum} [enum]
     * @param wakeup WebIDL type: boolean
     */
    public static void addForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos, int mode, boolean wakeup) {
        _addForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode, wakeup);
    }
    private static native void _addForceAtLocalPos(long body, long force, long pos, int mode, boolean wakeup);

    /**
     * @param body  WebIDL type: {@link PxRigidBody} [Ref]
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos   WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public static void addLocalForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos) {
        _addLocalForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress());
    }
    private static native void _addLocalForceAtPos(long body, long force, long pos);

    /**
     * @param body  WebIDL type: {@link PxRigidBody} [Ref]
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode  WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public static void addLocalForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos, int mode) {
        _addLocalForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode);
    }
    private static native void _addLocalForceAtPos(long body, long force, long pos, int mode);

    /**
     * @param body   WebIDL type: {@link PxRigidBody} [Ref]
     * @param force  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode   WebIDL type: {@link PxForceModeEnum} [enum]
     * @param wakeup WebIDL type: boolean
     */
    public static void addLocalForceAtPos(PxRigidBody body, PxVec3 force, PxVec3 pos, int mode, boolean wakeup) {
        _addLocalForceAtPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode, wakeup);
    }
    private static native void _addLocalForceAtPos(long body, long force, long pos, int mode, boolean wakeup);

    /**
     * @param body  WebIDL type: {@link PxRigidBody} [Ref]
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos   WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public static void addLocalForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos) {
        _addLocalForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress());
    }
    private static native void _addLocalForceAtLocalPos(long body, long force, long pos);

    /**
     * @param body  WebIDL type: {@link PxRigidBody} [Ref]
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode  WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public static void addLocalForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos, int mode) {
        _addLocalForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode);
    }
    private static native void _addLocalForceAtLocalPos(long body, long force, long pos, int mode);

    /**
     * @param body   WebIDL type: {@link PxRigidBody} [Ref]
     * @param force  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param pos    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode   WebIDL type: {@link PxForceModeEnum} [enum]
     * @param wakeup WebIDL type: boolean
     */
    public static void addLocalForceAtLocalPos(PxRigidBody body, PxVec3 force, PxVec3 pos, int mode, boolean wakeup) {
        _addLocalForceAtLocalPos(body.getAddress(), force.getAddress(), pos.getAddress(), mode, wakeup);
    }
    private static native void _addLocalForceAtLocalPos(long body, long force, long pos, int mode, boolean wakeup);

    /**
     * @param body WebIDL type: {@link PxRigidBody} [Const, Ref]
     * @param pos  WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public static PxVec3 getVelocityAtPos(PxRigidBody body, PxVec3 pos) {
        return PxVec3.wrapPointer(_getVelocityAtPos(body.getAddress(), pos.getAddress()));
    }
    private static native long _getVelocityAtPos(long body, long pos);

    /**
     * @param body WebIDL type: {@link PxRigidBody} [Const, Ref]
     * @param pos  WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public static PxVec3 getLocalVelocityAtLocalPos(PxRigidBody body, PxVec3 pos) {
        return PxVec3.wrapPointer(_getLocalVelocityAtLocalPos(body.getAddress(), pos.getAddress()));
    }
    private static native long _getLocalVelocityAtLocalPos(long body, long pos);

    /**
     * @param body WebIDL type: {@link PxRigidBody} [Const, Ref]
     * @param pos  WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public static PxVec3 getVelocityAtOffset(PxRigidBody body, PxVec3 pos) {
        return PxVec3.wrapPointer(_getVelocityAtOffset(body.getAddress(), pos.getAddress()));
    }
    private static native long _getVelocityAtOffset(long body, long pos);

    /**
     * @param body                 WebIDL type: {@link PxRigidBody} [Const, Ref]
     * @param impulsiveForce       WebIDL type: {@link PxVec3} [Const, Ref]
     * @param impulsiveTorque      WebIDL type: {@link PxVec3} [Const, Ref]
     * @param deltaLinearVelocity  WebIDL type: {@link PxVec3} [Ref]
     * @param deltaAngularVelocity WebIDL type: {@link PxVec3} [Ref]
     */
    public static void computeVelocityDeltaFromImpulse(PxRigidBody body, PxVec3 impulsiveForce, PxVec3 impulsiveTorque, PxVec3 deltaLinearVelocity, PxVec3 deltaAngularVelocity) {
        _computeVelocityDeltaFromImpulse(body.getAddress(), impulsiveForce.getAddress(), impulsiveTorque.getAddress(), deltaLinearVelocity.getAddress(), deltaAngularVelocity.getAddress());
    }
    private static native void _computeVelocityDeltaFromImpulse(long body, long impulsiveForce, long impulsiveTorque, long deltaLinearVelocity, long deltaAngularVelocity);

    /**
     * @param body                 WebIDL type: {@link PxRigidBody} [Const, Ref]
     * @param globalPose           WebIDL type: {@link PxTransform} [Const, Ref]
     * @param point                WebIDL type: {@link PxVec3} [Const, Ref]
     * @param impulse              WebIDL type: {@link PxVec3} [Const, Ref]
     * @param invMassScale         WebIDL type: float
     * @param invInertiaScale      WebIDL type: float
     * @param deltaLinearVelocity  WebIDL type: {@link PxVec3} [Ref]
     * @param deltaAngularVelocity WebIDL type: {@link PxVec3} [Ref]
     */
    public static void computeVelocityDeltaFromImpulse(PxRigidBody body, PxTransform globalPose, PxVec3 point, PxVec3 impulse, float invMassScale, float invInertiaScale, PxVec3 deltaLinearVelocity, PxVec3 deltaAngularVelocity) {
        _computeVelocityDeltaFromImpulse(body.getAddress(), globalPose.getAddress(), point.getAddress(), impulse.getAddress(), invMassScale, invInertiaScale, deltaLinearVelocity.getAddress(), deltaAngularVelocity.getAddress());
    }
    private static native void _computeVelocityDeltaFromImpulse(long body, long globalPose, long point, long impulse, float invMassScale, float invInertiaScale, long deltaLinearVelocity, long deltaAngularVelocity);

    /**
     * @param body            WebIDL type: {@link PxRigidBody} [Const, Ref]
     * @param globalPose      WebIDL type: {@link PxTransform} [Const, Ref]
     * @param point           WebIDL type: {@link PxVec3} [Const, Ref]
     * @param impulse         WebIDL type: {@link PxVec3} [Const, Ref]
     * @param invMassScale    WebIDL type: float
     * @param invInertiaScale WebIDL type: float
     * @param linearImpulse   WebIDL type: {@link PxVec3} [Ref]
     * @param angularImpulse  WebIDL type: {@link PxVec3} [Ref]
     */
    public static void computeLinearAngularImpulse(PxRigidBody body, PxTransform globalPose, PxVec3 point, PxVec3 impulse, float invMassScale, float invInertiaScale, PxVec3 linearImpulse, PxVec3 angularImpulse) {
        _computeLinearAngularImpulse(body.getAddress(), globalPose.getAddress(), point.getAddress(), impulse.getAddress(), invMassScale, invInertiaScale, linearImpulse.getAddress(), angularImpulse.getAddress());
    }
    private static native void _computeLinearAngularImpulse(long body, long globalPose, long point, long impulse, float invMassScale, float invInertiaScale, long linearImpulse, long angularImpulse);

}
