package physx.vehicle;

import physx.NativeObject;

public class PxVehicleWheelQueryResult extends NativeObject {

    public static PxVehicleWheelQueryResult wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelQueryResult(address) : null;
    }
    
    protected PxVehicleWheelQueryResult(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleWheelQueryResult() {
        address = _PxVehicleWheelQueryResult();
    }
    private static native long _PxVehicleWheelQueryResult();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxWheelQueryResult}
     */
    public PxWheelQueryResult getWheelQueryResults() {
        checkNotNull();
        return PxWheelQueryResult.wrapPointer(_getWheelQueryResults(address));
    }
    private static native long _getWheelQueryResults(long address);

    /**
     * @param value WebIDL type: {@link PxWheelQueryResult}
     */
    public void setWheelQueryResults(PxWheelQueryResult value) {
        checkNotNull();
        _setWheelQueryResults(address, value.getAddress());
    }
    private static native void _setWheelQueryResults(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelQueryResults() {
        checkNotNull();
        return _getNbWheelQueryResults(address);
    }
    private static native int _getNbWheelQueryResults(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbWheelQueryResults(int value) {
        checkNotNull();
        _setNbWheelQueryResults(address, value);
    }
    private static native void _setNbWheelQueryResults(long address, int value);

}
