package physx.common;

import physx.NativeObject;

public class PxBounds3 extends NativeObject {

    public static PxBounds3 wrapPointer(long address) {
        return address != 0L ? new PxBounds3(address) : null;
    }
    
    protected PxBounds3(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxBounds3
     */
    public static PxBounds3 createAt(long address) {
        __placement_new_PxBounds3(address);
        PxBounds3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxBounds3
     */
    public static <T> PxBounds3 createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxBounds3(address);
        PxBounds3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxBounds3(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param minimum WebIDL type: {@link PxVec3} [Const, Ref]
     * @param maximum WebIDL type: {@link PxVec3} [Const, Ref]
     * @return Stack allocated object of PxBounds3
     */
    public static PxBounds3 createAt(long address, PxVec3 minimum, PxVec3 maximum) {
        __placement_new_PxBounds3(address, minimum.getAddress(), maximum.getAddress());
        PxBounds3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param minimum   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param maximum   WebIDL type: {@link PxVec3} [Const, Ref]
     * @return Stack allocated object of PxBounds3
     */
    public static <T> PxBounds3 createAt(T allocator, Allocator<T> allocate, PxVec3 minimum, PxVec3 maximum) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxBounds3(address, minimum.getAddress(), maximum.getAddress());
        PxBounds3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxBounds3(long address, long minimum, long maximum);

    // Constructors

    public PxBounds3() {
        address = _PxBounds3();
    }
    private static native long _PxBounds3();

    /**
     * @param minimum WebIDL type: {@link PxVec3} [Const, Ref]
     * @param maximum WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public PxBounds3(PxVec3 minimum, PxVec3 maximum) {
        address = _PxBounds3(minimum.getAddress(), maximum.getAddress());
    }
    private static native long _PxBounds3(long minimum, long maximum);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getMinimum() {
        checkNotNull();
        return PxVec3.wrapPointer(_getMinimum(address));
    }
    private static native long _getMinimum(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setMinimum(PxVec3 value) {
        checkNotNull();
        _setMinimum(address, value.getAddress());
    }
    private static native void _setMinimum(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getMaximum() {
        checkNotNull();
        return PxVec3.wrapPointer(_getMaximum(address));
    }
    private static native long _getMaximum(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setMaximum(PxVec3 value) {
        checkNotNull();
        _setMaximum(address, value.getAddress());
    }
    private static native void _setMaximum(long address, long value);

    // Functions

    public void setEmpty() {
        checkNotNull();
        _setEmpty(address);
    }
    private static native void _setEmpty(long address);

    public void setMaximal() {
        checkNotNull();
        _setMaximal(address);
    }
    private static native void _setMaximal(long address);

    /**
     * @param v WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void include(PxVec3 v) {
        checkNotNull();
        _include(address, v.getAddress());
    }
    private static native void _include(long address, long v);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isEmpty() {
        checkNotNull();
        return _isEmpty(address);
    }
    private static native boolean _isEmpty(long address);

    /**
     * @param b WebIDL type: {@link PxBounds3} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean intersects(PxBounds3 b) {
        checkNotNull();
        return _intersects(address, b.getAddress());
    }
    private static native boolean _intersects(long address, long b);

    /**
     * @param b    WebIDL type: {@link PxBounds3} [Const, Ref]
     * @param axis WebIDL type: unsigned long
     * @return WebIDL type: boolean
     */
    public boolean intersects1D(PxBounds3 b, int axis) {
        checkNotNull();
        return _intersects1D(address, b.getAddress(), axis);
    }
    private static native boolean _intersects1D(long address, long b, int axis);

    /**
     * @param v WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean contains(PxVec3 v) {
        checkNotNull();
        return _contains(address, v.getAddress());
    }
    private static native boolean _contains(long address, long v);

    /**
     * @param box WebIDL type: {@link PxBounds3} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean isInside(PxBounds3 box) {
        checkNotNull();
        return _isInside(address, box.getAddress());
    }
    private static native boolean _isInside(long address, long box);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getCenter() {
        checkNotNull();
        return PxVec3.wrapPointer(_getCenter(address));
    }
    private static native long _getCenter(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getDimensions() {
        checkNotNull();
        return PxVec3.wrapPointer(_getDimensions(address));
    }
    private static native long _getDimensions(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getExtents() {
        checkNotNull();
        return PxVec3.wrapPointer(_getExtents(address));
    }
    private static native long _getExtents(long address);

    /**
     * @param scale WebIDL type: float
     */
    public void scaleSafe(float scale) {
        checkNotNull();
        _scaleSafe(address, scale);
    }
    private static native void _scaleSafe(long address, float scale);

    /**
     * @param scale WebIDL type: float
     */
    public void scaleFast(float scale) {
        checkNotNull();
        _scaleFast(address, scale);
    }
    private static native void _scaleFast(long address, float scale);

    /**
     * @param distance WebIDL type: float
     */
    public void fattenSafe(float distance) {
        checkNotNull();
        _fattenSafe(address, distance);
    }
    private static native void _fattenSafe(long address, float distance);

    /**
     * @param distance WebIDL type: float
     */
    public void fattenFast(float distance) {
        checkNotNull();
        _fattenFast(address, distance);
    }
    private static native void _fattenFast(long address, float distance);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isFinite() {
        checkNotNull();
        return _isFinite(address);
    }
    private static native boolean _isFinite(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
