package physx.extensions;

import physx.NativeObject;

public class PxPrismaticJointFlags extends NativeObject {

    protected PxPrismaticJointFlags() { }

    public static PxPrismaticJointFlags wrapPointer(long address) {
        return address != 0L ? new PxPrismaticJointFlags(address) : null;
    }
    
    protected PxPrismaticJointFlags(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param flags WebIDL type: unsigned short
     */
    public PxPrismaticJointFlags(short flags) {
        address = _PxPrismaticJointFlags(flags);
    }
    private static native long _PxPrismaticJointFlags(short flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxPrismaticJointFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(int flag) {
        checkNotNull();
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxPrismaticJointFlagEnum} [enum]
     */
    public void set(int flag) {
        checkNotNull();
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxPrismaticJointFlagEnum} [enum]
     */
    public void clear(int flag) {
        checkNotNull();
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
