package physx.physics;

import physx.common.PxQuat;
import physx.common.PxVec3;

public class PxArticulationJoint extends PxArticulationJointBase {

    protected PxArticulationJoint() { }

    public static PxArticulationJoint wrapPointer(long address) {
        return address != 0L ? new PxArticulationJoint(address) : null;
    }
    
    protected PxArticulationJoint(long address) {
        super(address);
    }

    // Functions

    /**
     * @param orientation WebIDL type: {@link PxQuat} [Const, Ref]
     */
    public void setTargetOrientation(PxQuat orientation) {
        checkNotNull();
        _setTargetOrientation(address, orientation.getAddress());
    }
    private static native void _setTargetOrientation(long address, long orientation);

    /**
     * @return WebIDL type: {@link PxQuat} [Value]
     */
    public PxQuat getTargetOrientation() {
        checkNotNull();
        return PxQuat.wrapPointer(_getTargetOrientation(address));
    }
    private static native long _getTargetOrientation(long address);

    /**
     * @param velocity WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setTargetVelocity(PxVec3 velocity) {
        checkNotNull();
        _setTargetVelocity(address, velocity.getAddress());
    }
    private static native void _setTargetVelocity(long address, long velocity);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTargetVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getTargetVelocity(address));
    }
    private static native long _getTargetVelocity(long address);

    /**
     * @param driveType WebIDL type: {@link PxArticulationJointDriveTypeEnum} [enum]
     */
    public void setDriveType(int driveType) {
        checkNotNull();
        _setDriveType(address, driveType);
    }
    private static native void _setDriveType(long address, int driveType);

    /**
     * @return WebIDL type: {@link PxArticulationJointDriveTypeEnum} [enum]
     */
    public int getDriveType() {
        checkNotNull();
        return _getDriveType(address);
    }
    private static native int _getDriveType(long address);

    /**
     * @param spring WebIDL type: float
     */
    public void setStiffness(float spring) {
        checkNotNull();
        _setStiffness(address, spring);
    }
    private static native void _setStiffness(long address, float spring);

    /**
     * @return WebIDL type: float
     */
    public float getStiffness() {
        checkNotNull();
        return _getStiffness(address);
    }
    private static native float _getStiffness(long address);

    /**
     * @param damping WebIDL type: float
     */
    public void setDamping(float damping) {
        checkNotNull();
        _setDamping(address, damping);
    }
    private static native void _setDamping(long address, float damping);

    /**
     * @return WebIDL type: float
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * @param compliance WebIDL type: float
     */
    public void setInternalCompliance(float compliance) {
        checkNotNull();
        _setInternalCompliance(address, compliance);
    }
    private static native void _setInternalCompliance(long address, float compliance);

    /**
     * @return WebIDL type: float
     */
    public float getInternalCompliance() {
        checkNotNull();
        return _getInternalCompliance(address);
    }
    private static native float _getInternalCompliance(long address);

    /**
     * @param compliance WebIDL type: float
     */
    public void setExternalCompliance(float compliance) {
        checkNotNull();
        _setExternalCompliance(address, compliance);
    }
    private static native void _setExternalCompliance(long address, float compliance);

    /**
     * @return WebIDL type: float
     */
    public float getExternalCompliance() {
        checkNotNull();
        return _getExternalCompliance(address);
    }
    private static native float _getExternalCompliance(long address);

    /**
     * @param zLimit WebIDL type: float
     * @param yLimit WebIDL type: float
     */
    public void setSwingLimit(float zLimit, float yLimit) {
        checkNotNull();
        _setSwingLimit(address, zLimit, yLimit);
    }
    private static native void _setSwingLimit(long address, float zLimit, float yLimit);

    /**
     * @param spring WebIDL type: float
     */
    public void setTangentialStiffness(float spring) {
        checkNotNull();
        _setTangentialStiffness(address, spring);
    }
    private static native void _setTangentialStiffness(long address, float spring);

    /**
     * @return WebIDL type: float
     */
    public float getTangentialStiffness() {
        checkNotNull();
        return _getTangentialStiffness(address);
    }
    private static native float _getTangentialStiffness(long address);

    /**
     * @param damping WebIDL type: float
     */
    public void setTangentialDamping(float damping) {
        checkNotNull();
        _setTangentialDamping(address, damping);
    }
    private static native void _setTangentialDamping(long address, float damping);

    /**
     * @return WebIDL type: float
     */
    public float getTangentialDamping() {
        checkNotNull();
        return _getTangentialDamping(address);
    }
    private static native float _getTangentialDamping(long address);

    /**
     * @param contactDistance WebIDL type: float
     */
    public void setSwingLimitContactDistance(float contactDistance) {
        checkNotNull();
        _setSwingLimitContactDistance(address, contactDistance);
    }
    private static native void _setSwingLimitContactDistance(long address, float contactDistance);

    /**
     * @return WebIDL type: float
     */
    public float getSwingLimitContactDistance() {
        checkNotNull();
        return _getSwingLimitContactDistance(address);
    }
    private static native float _getSwingLimitContactDistance(long address);

    /**
     * @param enabled WebIDL type: boolean
     */
    public void setSwingLimitEnabled(boolean enabled) {
        checkNotNull();
        _setSwingLimitEnabled(address, enabled);
    }
    private static native void _setSwingLimitEnabled(long address, boolean enabled);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getSwingLimitEnabled() {
        checkNotNull();
        return _getSwingLimitEnabled(address);
    }
    private static native boolean _getSwingLimitEnabled(long address);

    /**
     * @param lower WebIDL type: float
     * @param upper WebIDL type: float
     */
    public void setTwistLimit(float lower, float upper) {
        checkNotNull();
        _setTwistLimit(address, lower, upper);
    }
    private static native void _setTwistLimit(long address, float lower, float upper);

    /**
     * @param enabled WebIDL type: boolean
     */
    public void setTwistLimitEnabled(boolean enabled) {
        checkNotNull();
        _setTwistLimitEnabled(address, enabled);
    }
    private static native void _setTwistLimitEnabled(long address, boolean enabled);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getTwistLimitEnabled() {
        checkNotNull();
        return _getTwistLimitEnabled(address);
    }
    private static native boolean _getTwistLimitEnabled(long address);

    /**
     * @param contactDistance WebIDL type: float
     */
    public void setTwistLimitContactDistance(float contactDistance) {
        checkNotNull();
        _setTwistLimitContactDistance(address, contactDistance);
    }
    private static native void _setTwistLimitContactDistance(long address, float contactDistance);

    /**
     * @return WebIDL type: float
     */
    public float getTwistLimitContactDistance() {
        checkNotNull();
        return _getTwistLimitContactDistance(address);
    }
    private static native float _getTwistLimitContactDistance(long address);

}
