package physx.vehicle;

import physx.NativeObject;

public class PxVehicleWheelsDynData extends NativeObject {

    protected PxVehicleWheelsDynData() { }

    public static PxVehicleWheelsDynData wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelsDynData(address) : null;
    }
    
    protected PxVehicleWheelsDynData(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    public void setToRestState() {
        checkNotNull();
        _setToRestState(address);
    }
    private static native void _setToRestState(long address);

    /**
     * @param wheelIdx WebIDL type: unsigned long
     * @param speed    WebIDL type: float
     */
    public void setWheelRotationSpeed(int wheelIdx, float speed) {
        checkNotNull();
        _setWheelRotationSpeed(address, wheelIdx, speed);
    }
    private static native void _setWheelRotationSpeed(long address, int wheelIdx, float speed);

    /**
     * @param wheelIdx WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float getWheelRotationSpeed(int wheelIdx) {
        checkNotNull();
        return _getWheelRotationSpeed(address, wheelIdx);
    }
    private static native float _getWheelRotationSpeed(long address, int wheelIdx);

    /**
     * @param wheelIdx WebIDL type: unsigned long
     * @param angle    WebIDL type: float
     */
    public void setWheelRotationAngle(int wheelIdx, float angle) {
        checkNotNull();
        _setWheelRotationAngle(address, wheelIdx, angle);
    }
    private static native void _setWheelRotationAngle(long address, int wheelIdx, float angle);

    /**
     * @param wheelIdx WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float getWheelRotationAngle(int wheelIdx) {
        checkNotNull();
        return _getWheelRotationAngle(address, wheelIdx);
    }
    private static native float _getWheelRotationAngle(long address, int wheelIdx);

    /**
     * @param src      WebIDL type: {@link PxVehicleWheelsDynData} [Const, Ref]
     * @param srcWheel WebIDL type: unsigned long
     * @param trgWheel WebIDL type: unsigned long
     */
    public void copy(PxVehicleWheelsDynData src, int srcWheel, int trgWheel) {
        checkNotNull();
        _copy(address, src.getAddress(), srcWheel, trgWheel);
    }
    private static native void _copy(long address, long src, int srcWheel, int trgWheel);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelRotationSpeed() {
        checkNotNull();
        return _getNbWheelRotationSpeed(address);
    }
    private static native int _getNbWheelRotationSpeed(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelRotationAngle() {
        checkNotNull();
        return _getNbWheelRotationAngle(address);
    }
    private static native int _getNbWheelRotationAngle(long address);

}
