package physx.character;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.physics.PxRigidDynamic;
import physx.physics.PxScene;

public class PxController extends NativeObject {

    protected PxController() { }

    public static PxController wrapPointer(long address) {
        return address != 0L ? new PxController(address) : null;
    }
    
    protected PxController(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: {@link PxControllerShapeTypeEnum} [enum]
     */
    public int getType() {
        checkNotNull();
        return _getType(address);
    }
    private static native int _getType(long address);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @param disp        WebIDL type: {@link PxVec3} [Const, Ref]
     * @param minDist     WebIDL type: float
     * @param elapsedTime WebIDL type: float
     * @param filters     WebIDL type: {@link PxControllerFilters} [Const, Ref]
     * @return WebIDL type: {@link PxControllerCollisionFlags} [Value]
     */
    public PxControllerCollisionFlags move(PxVec3 disp, float minDist, float elapsedTime, PxControllerFilters filters) {
        checkNotNull();
        return PxControllerCollisionFlags.wrapPointer(_move(address, disp.getAddress(), minDist, elapsedTime, filters.getAddress()));
    }
    private static native long _move(long address, long disp, float minDist, float elapsedTime, long filters);

    /**
     * @param disp        WebIDL type: {@link PxVec3} [Const, Ref]
     * @param minDist     WebIDL type: float
     * @param elapsedTime WebIDL type: float
     * @param filters     WebIDL type: {@link PxControllerFilters} [Const, Ref]
     * @param obstacles   WebIDL type: {@link PxObstacleContext} [Const]
     * @return WebIDL type: {@link PxControllerCollisionFlags} [Value]
     */
    public PxControllerCollisionFlags move(PxVec3 disp, float minDist, float elapsedTime, PxControllerFilters filters, PxObstacleContext obstacles) {
        checkNotNull();
        return PxControllerCollisionFlags.wrapPointer(_move(address, disp.getAddress(), minDist, elapsedTime, filters.getAddress(), obstacles.getAddress()));
    }
    private static native long _move(long address, long disp, float minDist, float elapsedTime, long filters, long obstacles);

    /**
     * @param position WebIDL type: {@link PxExtendedVec3} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean setPosition(PxExtendedVec3 position) {
        checkNotNull();
        return _setPosition(address, position.getAddress());
    }
    private static native boolean _setPosition(long address, long position);

    /**
     * @return WebIDL type: {@link PxExtendedVec3} [Const, Ref]
     */
    public PxExtendedVec3 getPosition() {
        checkNotNull();
        return PxExtendedVec3.wrapPointer(_getPosition(address));
    }
    private static native long _getPosition(long address);

    /**
     * @param position WebIDL type: {@link PxExtendedVec3} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean setFootPosition(PxExtendedVec3 position) {
        checkNotNull();
        return _setFootPosition(address, position.getAddress());
    }
    private static native boolean _setFootPosition(long address, long position);

    /**
     * @return WebIDL type: {@link PxExtendedVec3} [Value]
     */
    public PxExtendedVec3 getFootPosition() {
        checkNotNull();
        return PxExtendedVec3.wrapPointer(_getFootPosition(address));
    }
    private static native long _getFootPosition(long address);

    /**
     * @return WebIDL type: {@link PxRigidDynamic}
     */
    public PxRigidDynamic getActor() {
        checkNotNull();
        return PxRigidDynamic.wrapPointer(_getActor(address));
    }
    private static native long _getActor(long address);

    /**
     * @param offset WebIDL type: float
     */
    public void setStepOffset(float offset) {
        checkNotNull();
        _setStepOffset(address, offset);
    }
    private static native void _setStepOffset(long address, float offset);

    /**
     * @return WebIDL type: float
     */
    public float getStepOffset() {
        checkNotNull();
        return _getStepOffset(address);
    }
    private static native float _getStepOffset(long address);

    /**
     * @param flag WebIDL type: {@link PxControllerNonWalkableModeEnum} [enum]
     */
    public void setNonWalkableMode(int flag) {
        checkNotNull();
        _setNonWalkableMode(address, flag);
    }
    private static native void _setNonWalkableMode(long address, int flag);

    /**
     * @return WebIDL type: {@link PxControllerNonWalkableModeEnum} [enum]
     */
    public int getNonWalkableMode() {
        checkNotNull();
        return _getNonWalkableMode(address);
    }
    private static native int _getNonWalkableMode(long address);

    /**
     * @return WebIDL type: float
     */
    public float getContactOffset() {
        checkNotNull();
        return _getContactOffset(address);
    }
    private static native float _getContactOffset(long address);

    /**
     * @param offset WebIDL type: float
     */
    public void setContactOffset(float offset) {
        checkNotNull();
        _setContactOffset(address, offset);
    }
    private static native void _setContactOffset(long address, float offset);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getUpDirection() {
        checkNotNull();
        return PxVec3.wrapPointer(_getUpDirection(address));
    }
    private static native long _getUpDirection(long address);

    /**
     * @param up WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setUpDirection(PxVec3 up) {
        checkNotNull();
        _setUpDirection(address, up.getAddress());
    }
    private static native void _setUpDirection(long address, long up);

    /**
     * @return WebIDL type: float
     */
    public float getSlopeLimit() {
        checkNotNull();
        return _getSlopeLimit(address);
    }
    private static native float _getSlopeLimit(long address);

    /**
     * @param slopeLimit WebIDL type: float
     */
    public void setSlopeLimit(float slopeLimit) {
        checkNotNull();
        _setSlopeLimit(address, slopeLimit);
    }
    private static native void _setSlopeLimit(long address, float slopeLimit);

    public void invalidateCache() {
        checkNotNull();
        _invalidateCache(address);
    }
    private static native void _invalidateCache(long address);

    /**
     * @return WebIDL type: {@link PxScene}
     */
    public PxScene getScene() {
        checkNotNull();
        return PxScene.wrapPointer(_getScene(address));
    }
    private static native long _getScene(long address);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param userData WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject userData) {
        checkNotNull();
        _setUserData(address, userData.getAddress());
    }
    private static native void _setUserData(long address, long userData);

    /**
     * @param state WebIDL type: {@link PxControllerState} [Ref]
     */
    public void getState(PxControllerState state) {
        checkNotNull();
        _getState(address, state.getAddress());
    }
    private static native void _getState(long address, long state);

    /**
     * @param stats WebIDL type: {@link PxControllerStats} [Ref]
     */
    public void getStats(PxControllerStats stats) {
        checkNotNull();
        _getStats(address, stats.getAddress());
    }
    private static native void _getStats(long address, long stats);

    /**
     * @param height WebIDL type: float
     */
    public void resize(float height) {
        checkNotNull();
        _resize(address, height);
    }
    private static native void _resize(long address, float height);

}
