package physx.character;

import physx.NativeObject;
import physx.physics.PxFilterData;
import physx.physics.PxQueryFlags;

public class PxControllerFilters extends NativeObject {

    public static PxControllerFilters wrapPointer(long address) {
        return address != 0L ? new PxControllerFilters(address) : null;
    }
    
    protected PxControllerFilters(long address) {
        super(address);
    }

    // Constructors

    public PxControllerFilters() {
        address = _PxControllerFilters();
    }
    private static native long _PxControllerFilters();

    /**
     * @param filterData WebIDL type: {@link PxFilterData} [Const]
     */
    public PxControllerFilters(PxFilterData filterData) {
        address = _PxControllerFilters(filterData.getAddress());
    }
    private static native long _PxControllerFilters(long filterData);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxFilterData} [Const]
     */
    public PxFilterData getMFilterData() {
        checkNotNull();
        return PxFilterData.wrapPointer(_getMFilterData(address));
    }
    private static native long _getMFilterData(long address);

    /**
     * @param value WebIDL type: {@link PxFilterData} [Const]
     */
    public void setMFilterData(PxFilterData value) {
        checkNotNull();
        _setMFilterData(address, value.getAddress());
    }
    private static native void _setMFilterData(long address, long value);

    /**
     * @return WebIDL type: {@link PxQueryFlags} [Value]
     */
    public PxQueryFlags getMFilterFlags() {
        checkNotNull();
        return PxQueryFlags.wrapPointer(_getMFilterFlags(address));
    }
    private static native long _getMFilterFlags(long address);

    /**
     * @param value WebIDL type: {@link PxQueryFlags} [Value]
     */
    public void setMFilterFlags(PxQueryFlags value) {
        checkNotNull();
        _setMFilterFlags(address, value.getAddress());
    }
    private static native void _setMFilterFlags(long address, long value);

}
