package physx.character;

import physx.NativeObject;

public class PxUserControllerHitReport extends NativeObject {

    protected PxUserControllerHitReport() { }

    public static PxUserControllerHitReport wrapPointer(long address) {
        return address != 0L ? new PxUserControllerHitReport(address) : null;
    }
    
    protected PxUserControllerHitReport(long address) {
        super(address);
    }

    // Functions

    /**
     * @param hit WebIDL type: {@link PxControllerShapeHit} [Const, Ref]
     */
    public void onShapeHit(PxControllerShapeHit hit) {
        checkNotNull();
        _onShapeHit(address, hit.getAddress());
    }
    private static native void _onShapeHit(long address, long hit);

    /**
     * @param hit WebIDL type: {@link PxControllersHit} [Const, Ref]
     */
    public void onControllerHit(PxControllersHit hit) {
        checkNotNull();
        _onControllerHit(address, hit.getAddress());
    }
    private static native void _onControllerHit(long address, long hit);

    /**
     * @param hit WebIDL type: {@link PxControllerObstacleHit} [Const, Ref]
     */
    public void onObstacleHit(PxControllerObstacleHit hit) {
        checkNotNull();
        _onObstacleHit(address, hit.getAddress());
    }
    private static native void _onObstacleHit(long address, long hit);

}
