package physx.character;

import physx.physics.PxActor;
import physx.physics.PxShape;

public class SimpleControllerBehaviorCallback extends PxControllerBehaviorCallback {

    protected SimpleControllerBehaviorCallback() { }

    public static SimpleControllerBehaviorCallback wrapPointer(long address) {
        return address != 0L ? new SimpleControllerBehaviorCallback(address) : null;
    }
    
    protected SimpleControllerBehaviorCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param shape WebIDL type: {@link PxShape} [Const, Ref]
     * @param actor WebIDL type: {@link PxActor} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int getShapeBehaviorFlags(PxShape shape, PxActor actor) {
        checkNotNull();
        return _getShapeBehaviorFlags(address, shape.getAddress(), actor.getAddress());
    }
    private static native int _getShapeBehaviorFlags(long address, long shape, long actor);

    /**
     * @param controller WebIDL type: {@link PxController} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int getControllerBehaviorFlags(PxController controller) {
        checkNotNull();
        return _getControllerBehaviorFlags(address, controller.getAddress());
    }
    private static native int _getControllerBehaviorFlags(long address, long controller);

    /**
     * @param obstacle WebIDL type: {@link PxObstacle} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int getObstacleBehaviorFlags(PxObstacle obstacle) {
        checkNotNull();
        return _getObstacleBehaviorFlags(address, obstacle.getAddress());
    }
    private static native int _getObstacleBehaviorFlags(long address, long obstacle);

}
