package physx.common;

import physx.NativeObject;

public class PxCollection extends NativeObject {

    protected PxCollection() { }

    public static PxCollection wrapPointer(long address) {
        return address != 0L ? new PxCollection(address) : null;
    }
    
    protected PxCollection(long address) {
        super(address);
    }

    // Functions

    /**
     * @param obj WebIDL type: {@link PxBase} [Ref]
     */
    public void add(PxBase obj) {
        checkNotNull();
        _add(address, obj.getAddress());
    }
    private static native void _add(long address, long obj);

    /**
     * @param obj WebIDL type: {@link PxBase} [Ref]
     * @param id  WebIDL type: unsigned long long
     */
    public void add(PxBase obj, long id) {
        checkNotNull();
        _add(address, obj.getAddress(), id);
    }
    private static native void _add(long address, long obj, long id);

    /**
     * @param obj WebIDL type: {@link PxBase} [Ref]
     */
    public void remove(PxBase obj) {
        checkNotNull();
        _remove(address, obj.getAddress());
    }
    private static native void _remove(long address, long obj);

    /**
     * @param obj WebIDL type: {@link PxBase} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean contains(PxBase obj) {
        checkNotNull();
        return _contains(address, obj.getAddress());
    }
    private static native boolean _contains(long address, long obj);

    /**
     * @param obj WebIDL type: {@link PxBase} [Ref]
     * @param id  WebIDL type: unsigned long long
     */
    public void addId(PxBase obj, long id) {
        checkNotNull();
        _addId(address, obj.getAddress(), id);
    }
    private static native void _addId(long address, long obj, long id);

    /**
     * @param id WebIDL type: unsigned long long
     */
    public void removeId(long id) {
        checkNotNull();
        _removeId(address, id);
    }
    private static native void _removeId(long address, long id);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbObjects() {
        checkNotNull();
        return _getNbObjects(address);
    }
    private static native int _getNbObjects(long address);

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxBase} [Ref]
     */
    public PxBase getObject(int index) {
        checkNotNull();
        return PxBase.wrapPointer(_getObject(address, index));
    }
    private static native long _getObject(long address, int index);

    /**
     * @param id WebIDL type: unsigned long long
     * @return WebIDL type: {@link PxBase}
     */
    public PxBase find(long id) {
        checkNotNull();
        return PxBase.wrapPointer(_find(address, id));
    }
    private static native long _find(long address, long id);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbIds() {
        checkNotNull();
        return _getNbIds(address);
    }
    private static native int _getNbIds(long address);

    /**
     * @param obj WebIDL type: {@link PxBase} [Const, Ref]
     * @return WebIDL type: unsigned long long
     */
    public long getId(PxBase obj) {
        checkNotNull();
        return _getId(address, obj.getAddress());
    }
    private static native long _getId(long address, long obj);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

}
